/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.metadata.visitor;

import cn.jrack.metadata.ast.Clickhouse20CreateTableStatement;
import cn.jrack.metadata.visitor.Clickhouse20Visitor;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class Clickhouse20OutputVisitor
extends SQLASTOutputVisitor
implements Clickhouse20Visitor {
    public Clickhouse20OutputVisitor(Appendable appender) {
        super(appender, DbType.clickhouse);
    }

    public Clickhouse20OutputVisitor(Appendable appender, DbType dbType) {
        super(appender, dbType);
    }

    public Clickhouse20OutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
    }

    public boolean visit(SQLWithSubqueryClause.Entry x) {
        if (x.getExpr() != null) {
            x.getExpr().accept((SQLASTVisitor)this);
        } else if (x.getSubQuery() != null) {
            this.print('(');
            this.println();
            SQLSelect query = x.getSubQuery();
            if (query != null) {
                query.accept((SQLASTVisitor)this);
            } else {
                x.getReturningStatement().accept((SQLASTVisitor)this);
            }
            this.println();
            this.print(')');
        }
        this.print(' ');
        this.print0(this.ucase ? "AS " : "as ");
        this.print0(x.getAlias());
        return false;
    }

    public boolean visit(SQLStructDataType x) {
        this.print0(this.ucase ? "NESTED (" : "nested (");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getFields(), ",");
        this.decrementIndent();
        this.println();
        this.print(')');
        return false;
    }

    public boolean visit(SQLStructDataType.Field x) {
        SQLDataType dataType;
        SQLName name = x.getName();
        if (name != null) {
            name.accept((SQLASTVisitor)this);
        }
        if ((dataType = x.getDataType()) != null) {
            this.print(' ');
            dataType.accept((SQLASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(Clickhouse20CreateTableStatement x) {
        List<SQLAssignItem> settings;
        SQLExpr sampleBy;
        SQLOrderBy orderBy;
        super.visit((SQLCreateTableStatement)x);
        SQLExpr partitionBy = x.getPartitionBy();
        if (partitionBy != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            partitionBy.accept((SQLASTVisitor)this);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            orderBy.accept((SQLASTVisitor)this);
        }
        if ((sampleBy = x.getSampleBy()) != null) {
            this.println();
            this.print0(this.ucase ? "SAMPLE BY " : "sample by ");
            sampleBy.accept((SQLASTVisitor)this);
        }
        if (!(settings = x.getSettings()).isEmpty()) {
            this.println();
            this.print0(this.ucase ? "SETTINGS " : "settings ");
            this.printAndAccept(settings, ", ");
        }
        return false;
    }

    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        this.printAndAccept(x.getColumns(), ", ");
        return false;
    }
}

