/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.metadata.driver;

import cn.jrack.core.util.LogUtil;
import cn.jrack.metadata.ast.Clickhouse20CreateTableStatement;
import cn.jrack.metadata.convert.ClickHouseTypeConvert;
import cn.jrack.metadata.convert.ITypeConvert;
import cn.jrack.metadata.driver.AbstractJdbcDriver;
import cn.jrack.metadata.parser.Clickhouse20StatementParser;
import cn.jrack.metadata.pojo.Table;
import cn.jrack.metadata.query.ClickHouseQuery;
import cn.jrack.metadata.query.IDBQuery;
import cn.jrack.metadata.result.SqlExplainResult;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.Token;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClickHouseDriver
extends AbstractJdbcDriver {
    String getDriverClass() {
        return "ru.yandex.clickhouse.ClickHouseDriver";
    }

    public IDBQuery getDBQuery() {
        return new ClickHouseQuery();
    }

    public ITypeConvert getTypeConvert() {
        return new ClickHouseTypeConvert();
    }

    public String getType() {
        return "ClickHouse";
    }

    public String getName() {
        return "ClickHouse OLAP \u6570\u636e\u5e93";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SqlExplainResult> explain(String sql) {
        String initialSql = sql;
        ArrayList<SqlExplainResult> sqlExplainResults = new ArrayList<SqlExplainResult>();
        StringBuilder explain = new StringBuilder();
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        String current = null;
        try {
            sql = sql.replaceAll("(?i)if exists", "");
            Clickhouse20StatementParser parser = new Clickhouse20StatementParser(sql);
            ArrayList stmtList = new ArrayList();
            parser.parseStatementList(stmtList, -1, null);
            if (parser.getLexer().token() != Token.EOF) {
                throw new ParserException("syntax error : " + sql);
            }
            for (SQLStatement item : stmtList) {
                current = item.toString();
                String type = item.getClass().getSimpleName();
                if (!(item instanceof SQLSelectStatement)) {
                    if (item instanceof Clickhouse20CreateTableStatement) {
                        Matcher m = Pattern.compile(",\\s*\\)").matcher(sql);
                        if (m.find()) {
                            sqlExplainResults.add(SqlExplainResult.fail((String)sql, (String)"No comma can be added to the last field of Table! "));
                        }
                        sqlExplainResults.add(this.checkCreateTable((Clickhouse20CreateTableStatement)item));
                        continue;
                    }
                    if (item instanceof SQLDropTableStatement) {
                        sqlExplainResults.add(this.checkDropTable((SQLDropTableStatement)item, initialSql));
                        continue;
                    }
                    sqlExplainResults.add(SqlExplainResult.success((String)type, (String)current, (String)explain.toString()));
                    continue;
                }
                preparedStatement = ((Connection)conn.get()).prepareStatement("explain " + current);
                results = preparedStatement.executeQuery();
                while (results.next()) {
                    explain.append(this.getTypeConvert().convertValue(results, "explain", "string") + "\r\n");
                }
                sqlExplainResults.add(SqlExplainResult.success((String)type, (String)current, (String)explain.toString()));
            }
        }
        catch (Exception e) {
            sqlExplainResults.add(SqlExplainResult.fail(current, (String)LogUtil.getError((Exception)e)));
        }
        finally {
            this.close(preparedStatement, results);
            return sqlExplainResults;
        }
    }

    private SqlExplainResult checkCreateTable(Clickhouse20CreateTableStatement sqlStatement) {
        if (this.existTable(Table.build((String)sqlStatement.getTableName()))) {
            if (sqlStatement.isIfNotExists()) {
                return SqlExplainResult.success((String)((Object)((Object)sqlStatement)).getClass().getSimpleName(), (String)sqlStatement.toString(), null);
            }
            String schema = null == sqlStatement.getSchema() ? "" : sqlStatement.getSchema() + ".";
            return SqlExplainResult.fail((String)sqlStatement.toString(), (String)("Table " + schema + sqlStatement.getTableName() + " already exists."));
        }
        return SqlExplainResult.success((String)((Object)((Object)sqlStatement)).getClass().getSimpleName(), (String)sqlStatement.toString(), null);
    }

    private SqlExplainResult checkDropTable(SQLDropTableStatement sqlStatement, String sql) {
        SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlStatement.getTableSources().get(0);
        if (!this.existTable(Table.build((String)sqlExprTableSource.getTableName()))) {
            if (Pattern.compile("(?i)if exists").matcher(sql).find()) {
                return SqlExplainResult.success((String)sqlStatement.getClass().getSimpleName(), (String)sqlStatement.toString(), null);
            }
            return SqlExplainResult.fail((String)sqlStatement.toString(), (String)("Table " + sqlExprTableSource.getSchema() + "." + sqlExprTableSource.getTableName() + " not exists."));
        }
        return SqlExplainResult.success((String)sqlStatement.getClass().getSimpleName(), (String)sqlStatement.toString(), null);
    }

    public Map<String, String> getFlinkColumnTypeConversion() {
        return new HashMap<String, String>();
    }
}

