/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.metadata.convert;

import cn.jrack.core.assertion.Asserts;
import cn.jrack.metadata.convert.ITypeConvert;
import cn.jrack.metadata.pojo.Column;
import cn.jrack.metadata.pojo.ColumnType;

public class ClickHouseTypeConvert
implements ITypeConvert {
    public ColumnType convert(Column column) {
        boolean isNullable;
        ColumnType columnType = ColumnType.STRING;
        if (Asserts.isNull((Object)column)) {
            return columnType;
        }
        String t = column.getType().toLowerCase();
        boolean bl = isNullable = !column.isKeyFlag() && column.isNullable();
        if (t.contains("tinyint")) {
            columnType = ColumnType.BYTE;
        } else if (t.contains("smallint") || t.contains("tinyint unsigned")) {
            columnType = isNullable ? ColumnType.JAVA_LANG_SHORT : ColumnType.SHORT;
        } else if (t.contains("bigint unsigned") || t.contains("numeric") || t.contains("decimal")) {
            columnType = ColumnType.DECIMAL;
        } else if (t.contains("bigint") || t.contains("int unsigned")) {
            columnType = isNullable ? ColumnType.JAVA_LANG_LONG : ColumnType.LONG;
        } else if (t.contains("float")) {
            columnType = isNullable ? ColumnType.JAVA_LANG_FLOAT : ColumnType.FLOAT;
        } else if (t.contains("double")) {
            columnType = isNullable ? ColumnType.JAVA_LANG_DOUBLE : ColumnType.DOUBLE;
        } else if (t.contains("boolean") || t.contains("tinyint(1)")) {
            columnType = isNullable ? ColumnType.JAVA_LANG_BOOLEAN : ColumnType.BOOLEAN;
        } else if (t.contains("datetime")) {
            columnType = ColumnType.TIMESTAMP;
        } else if (t.contains("date")) {
            columnType = ColumnType.DATE;
        } else if (t.contains("time")) {
            columnType = ColumnType.TIME;
        } else if (t.contains("char") || t.contains("text")) {
            columnType = ColumnType.STRING;
        } else if (t.contains("binary") || t.contains("blob")) {
            columnType = ColumnType.BYTES;
        } else if (t.contains("int") || t.contains("mediumint") || t.contains("smallint unsigned")) {
            columnType = isNullable ? ColumnType.INTEGER : ColumnType.INT;
        }
        return columnType;
    }

    public String convertToDB(ColumnType columnType) {
        switch (columnType) {
            case STRING: {
                return "varchar";
            }
            case BYTE: {
                return "tinyint";
            }
            case SHORT: 
            case JAVA_LANG_SHORT: {
                return "smallint";
            }
            case DECIMAL: {
                return "decimal";
            }
            case LONG: 
            case JAVA_LANG_LONG: {
                return "bigint";
            }
            case FLOAT: 
            case JAVA_LANG_FLOAT: {
                return "float";
            }
            case DOUBLE: 
            case JAVA_LANG_DOUBLE: {
                return "double";
            }
            case BOOLEAN: 
            case JAVA_LANG_BOOLEAN: {
                return "boolean";
            }
            case TIMESTAMP: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case BYTES: {
                return "binary";
            }
            case INTEGER: 
            case INT: {
                return "int";
            }
        }
        return "varchar";
    }
}

