/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.metadata.visitor;

import cn.jrack.metadata.visitor.Clickhouse20OutputVisitor;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import java.util.ArrayList;
import java.util.List;

public class Clickhouse20ExportParameterVisitor
extends Clickhouse20OutputVisitor
implements ExportParameterVisitor {
    private final boolean requireParameterizedOutput;

    public Clickhouse20ExportParameterVisitor(List<Object> parameters, Appendable appender, boolean wantParameterizedOutput) {
        super(appender, true);
        this.parameters = parameters;
        this.requireParameterizedOutput = wantParameterizedOutput;
    }

    public Clickhouse20ExportParameterVisitor() {
        this(new ArrayList<Object>());
    }

    public Clickhouse20ExportParameterVisitor(List<Object> parameters) {
        this(parameters, new StringBuilder(), false);
    }

    public Clickhouse20ExportParameterVisitor(Appendable appender) {
        this(new ArrayList<Object>(), appender, true);
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public boolean visit(SQLSelectItem x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    public boolean visit(SQLOrderBy x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    public boolean visit(SQLSelectGroupByClause x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        return false;
    }

    public boolean visit(SQLMethodInvokeExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept((List)this.parameters, (List)x.getArguments());
        return true;
    }

    public boolean visit(SQLInListExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParamterAndAccept((List)this.parameters, (List)x.getTargetList());
        return true;
    }

    public boolean visit(SQLBetweenExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParameter((List)this.parameters, (SQLBetweenExpr)x);
        return true;
    }

    public boolean visit(SQLBinaryOpExpr x) {
        if (this.requireParameterizedOutput) {
            return super.visit(x);
        }
        ExportParameterVisitorUtils.exportParameter((List)this.parameters, (SQLBinaryOpExpr)x);
        return true;
    }
}

