package cn.jrack.action.core.service;
import cn.jrack.action.api.IActionLog;
import cn.jrack.action.core.entity.ActionLogEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;


/**
 * 操作日志 Framework Service 实现类
 *
 * @author ZhaoYang
 */
@Service
public class ActionLogFrameworkServiceImpl implements ActionLogFrameworkService {


    @Autowired(required=false)
    private IActionLog iActionLog;

    @Override
    @Async
    public void createOperateLog(ActionLogEntity actionLog) {
        if(iActionLog!=null)
        {
            iActionLog.createOperateLog(actionLog);
        }else {
            System.out.println(actionLog);
        }

    }

}
