/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.flowable.flow;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.imageio.ImageIO;
import org.flowable.bpmn.model.AssociationDirection;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.image.impl.DefaultProcessDiagramCanvas;
import org.flowable.image.util.ReflectUtil;

public class CustomProcessDiagramCanvas
extends DefaultProcessDiagramCanvas {
    protected static Color HIGHLIGHT_SequenceFlow_COLOR = new Color(92, 184, 92, 1);
    protected static Color CONNECTION_COLOR = Color.BLACK;
    protected static Color LABEL_COLOR = new Color(0, 0, 0);
    protected static Color HIGHLIGHT_COLOR = new Color(92, 184, 92, 1);
    protected static Color HIGHLIGHT_COLOR1 = Color.RED;
    protected static Color EVENT_COLOR = new Color(255, 255, 255);

    public CustomProcessDiagramCanvas(int width, int height, int minX, int minY, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        super(width, height, minX, minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
        this.initialize(imageType);
    }

    public void drawConnection(int[] xPoints, int[] yPoints, boolean conditional, boolean isDefault, String connectionType, AssociationDirection associationDirection, boolean highLighted, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(CONNECTION_COLOR);
        if (connectionType.equals("association")) {
            this.g.setStroke(ASSOCIATION_STROKE);
        } else if (highLighted) {
            this.g.setPaint(HIGHLIGHT_SequenceFlow_COLOR);
            this.g.setStroke(HIGHLIGHT_FLOW_STROKE);
        }
        for (int i = 1; i < xPoints.length; ++i) {
            int sourceX = xPoints[i - 1];
            int sourceY = yPoints[i - 1];
            int targetX = xPoints[i];
            int targetY = yPoints[i];
            Line2D.Double line = new Line2D.Double(sourceX, sourceY, targetX, targetY);
            this.g.draw(line);
        }
        if (isDefault) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawDefaultSequenceFlowIndicator(line, scaleFactor);
        }
        if (conditional) {
            Line2D.Double line = new Line2D.Double(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
            this.drawConditionalSequenceFlowIndicator(line, scaleFactor);
        }
        if (associationDirection.equals((Object)AssociationDirection.ONE) || associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[xPoints.length - 2], yPoints[xPoints.length - 2], xPoints[xPoints.length - 1], yPoints[xPoints.length - 1]);
            this.drawArrowHead(line, scaleFactor);
        }
        if (associationDirection.equals((Object)AssociationDirection.BOTH)) {
            Line2D.Double line = new Line2D.Double(xPoints[1], yPoints[1], xPoints[0], yPoints[0]);
            this.drawArrowHead(line, scaleFactor);
        }
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void initialize(String imageType) {
        this.processDiagram = "png".equalsIgnoreCase(imageType) ? new BufferedImage(this.canvasWidth, this.canvasHeight, 2) : new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        this.g = this.processDiagram.createGraphics();
        if (!"png".equalsIgnoreCase(imageType)) {
            this.g.setBackground(new Color(255, 255, 255, 0));
            this.g.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font(this.activityFontName, 10, 14);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
        LABEL_FONT = new Font(this.labelFontName, 10, 15);
        ANNOTATION_FONT = new Font(this.annotationFontName, 0, 11);
        try {
            USERTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/userTask.png", (ClassLoader)this.customClassLoader));
            SCRIPTTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/scriptTask.png", (ClassLoader)this.customClassLoader));
            SERVICETASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/serviceTask.png", (ClassLoader)this.customClassLoader));
            RECEIVETASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/receiveTask.png", (ClassLoader)this.customClassLoader));
            SENDTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/sendTask.png", (ClassLoader)this.customClassLoader));
            MANUALTASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/manualTask.png", (ClassLoader)this.customClassLoader));
            BUSINESS_RULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/businessRuleTask.png", (ClassLoader)this.customClassLoader));
            SHELL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/shellTask.png", (ClassLoader)this.customClassLoader));
            DMN_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/dmnTask.png", (ClassLoader)this.customClassLoader));
            CAMEL_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/camelTask.png", (ClassLoader)this.customClassLoader));
            MULE_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/muleTask.png", (ClassLoader)this.customClassLoader));
            HTTP_TASK_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/httpTask.png", (ClassLoader)this.customClassLoader));
            TIMER_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/timer.png", (ClassLoader)this.customClassLoader));
            COMPENSATE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/compensate-throw.png", (ClassLoader)this.customClassLoader));
            COMPENSATE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/compensate.png", (ClassLoader)this.customClassLoader));
            ERROR_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/error-throw.png", (ClassLoader)this.customClassLoader));
            ERROR_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/error.png", (ClassLoader)this.customClassLoader));
            MESSAGE_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/message-throw.png", (ClassLoader)this.customClassLoader));
            MESSAGE_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/message.png", (ClassLoader)this.customClassLoader));
            SIGNAL_THROW_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/signal-throw.png", (ClassLoader)this.customClassLoader));
            SIGNAL_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResource((String)"org/flowable/icons/signal.png", (ClassLoader)this.customClassLoader));
        }
        catch (IOException var4) {
            LOGGER.warn("Could not load image for process diagram creation: {}", (Object)var4.getMessage());
        }
    }

    public void drawLabel(String text, GraphicInfo graphicInfo, boolean centered) {
        float interline = 1.0f;
        if (text != null && text.length() > 0) {
            Paint originalPaint = this.g.getPaint();
            Font originalFont = this.g.getFont();
            this.g.setPaint(LABEL_COLOR);
            this.g.setFont(LABEL_FONT);
            int wrapWidth = 100;
            int textY = (int)graphicInfo.getY();
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FOREGROUND, this.g.getPaint());
            as.addAttribute(TextAttribute.FONT, this.g.getFont());
            AttributedCharacterIterator aci = as.getIterator();
            FontRenderContext frc = new FontRenderContext(null, true, false);
            LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
            while (lbm.getPosition() < text.length()) {
                TextLayout tl = lbm.nextLayout(wrapWidth);
                textY = (int)((float)textY + tl.getAscent());
                Rectangle2D bb = tl.getBounds();
                double tX = graphicInfo.getX();
                if (centered) {
                    tX += (double)((int)(graphicInfo.getWidth() / 2.0 - bb.getWidth() / 2.0));
                }
                tl.draw(this.g, (float)tX, textY);
                textY = (int)((float)textY + (tl.getDescent() + tl.getLeading() + (interline - 1.0f) * tl.getAscent()));
            }
            this.g.setFont(originalFont);
            this.g.setPaint(originalPaint);
        }
    }

    public void drawHighLight(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawHighLightNow(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR1);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawHighLightEnd(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    protected void drawTask(String name, GraphicInfo graphicInfo, boolean thickBorder, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        this.g.setPaint(TASK_BOX_COLOR);
        int arcR = 6;
        if (thickBorder) {
            arcR = 3;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, arcR, arcR);
        this.g.fill(rect);
        this.g.setPaint(TASK_BORDER_COLOR);
        if (thickBorder) {
            Stroke originalStroke = this.g.getStroke();
            this.g.setStroke(THICK_TASK_BORDER_STROKE);
            this.g.draw(rect);
            this.g.setStroke(originalStroke);
        } else {
            this.g.draw(rect);
        }
        this.g.setPaint(originalPaint);
        if (scaleFactor == 1.0 && name != null && name.length() > 0) {
            int boxWidth = width - 6;
            int boxHeight = height - 16 - 5 - 5 - 12 - 2 - 2;
            int boxX = x + width / 2 - boxWidth / 2;
            int boxY = y + height / 2 - boxHeight / 2 + 5 + 5 - 2 - 2;
            this.drawMultilineCentredText(name, boxX, boxY, boxWidth, boxHeight);
        }
    }

    public void drawStartEvent(GraphicInfo graphicInfo, BufferedImage image, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(EVENT_COLOR);
        Ellipse2D.Double circle = new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        this.g.fill(circle);
        this.g.setPaint(EVENT_BORDER_COLOR);
        this.g.draw(circle);
        this.g.setPaint(originalPaint);
        if (image != null) {
            int imageX = (int)Math.round(graphicInfo.getX() + graphicInfo.getWidth() / 2.0 - (double)image.getWidth() / (2.0 * scaleFactor));
            int imageY = (int)Math.round(graphicInfo.getY() + graphicInfo.getHeight() / 2.0 - (double)image.getHeight() / (2.0 * scaleFactor));
            this.g.drawImage(image, imageX, imageY, (int)((double)image.getWidth() / scaleFactor), (int)((double)image.getHeight() / scaleFactor), null);
        }
    }

    public void drawNoneEndEvent(GraphicInfo graphicInfo, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(EVENT_COLOR);
        Ellipse2D.Double circle = new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        this.g.fill(circle);
        this.g.setPaint(EVENT_BORDER_COLOR);
        if (scaleFactor == 1.0) {
            this.g.setStroke(END_EVENT_STROKE);
        } else {
            this.g.setStroke(new BasicStroke(2.0f));
        }
        this.g.draw(circle);
        this.g.setStroke(originalStroke);
        this.g.setPaint(originalPaint);
    }
}

