package cn.jrack.flowable.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.jrack.flowable.common.constant.TaskConstants;
import cn.jrack.springboot.satoken.core.StUserInfo;
import cn.jrack.springboot.web.core.util.WebFrameworkUtils;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 工作流任务工具类
 *
 * @author konbai
 * @createTime 2022/4/24 12:42
 */
public class TaskUtils {

    public static String getUserId() {
        return String.valueOf(
                WebFrameworkUtils.getLoginUserId()
        );
    }

    /**
     * 获取用户组信息
     *
     * @return candidateGroup
     */
    public static List<String> getCandidateGroup() {
        List<String> list = new ArrayList<>();
        StUserInfo loginUserInfo = WebFrameworkUtils.getLoginUserInfo();

        if (ObjectUtil.isNotNull(loginUserInfo)) {
            if (ObjectUtil.isNotEmpty(loginUserInfo.getRoleIds())) {
                Arrays.stream(loginUserInfo.getRoleIds().split(","))
                        .forEach(role -> list.add(TaskConstants.ROLE_GROUP_PREFIX + role));
            }
            if (ObjectUtil.isNotNull(loginUserInfo.getDepartmentId())) {
                list.add(TaskConstants.DEPT_GROUP_PREFIX + loginUserInfo.getDepartmentId());
            }
        }
        return list;
    }
}
