/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.flowable.flow;

import cn.hutool.core.util.ObjectUtil;
import cn.jrack.core.exception.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableUtils {
    private static final Logger log = LoggerFactory.getLogger(FlowableUtils.class);

    public static List<SequenceFlow> getElementIncomingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof FlowNode) {
            sequenceFlows = ((FlowNode)source).getIncomingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getIncomingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getIncomingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getIncomingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getIncomingFlows();
        }
        return sequenceFlows;
    }

    public static List<SequenceFlow> getElementOutgoingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof FlowNode) {
            sequenceFlows = ((FlowNode)source).getOutgoingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getOutgoingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getOutgoingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getOutgoingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getOutgoingFlows();
        }
        return sequenceFlows;
    }

    public static Collection<FlowElement> getAllElements(Collection<FlowElement> flowElements, Collection<FlowElement> allElements) {
        allElements = allElements == null ? new ArrayList<FlowElement>() : allElements;
        for (FlowElement flowElement : flowElements) {
            allElements.add(flowElement);
            if (!(flowElement instanceof SubProcess)) continue;
            allElements = FlowableUtils.getAllElements(((SubProcess)flowElement).getFlowElements(), allElements);
        }
        return allElements;
    }

    public static List<UserTask> iteratorFindParentUserTasks(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        List<SequenceFlow> sequenceFlows;
        userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            userTaskList = FlowableUtils.iteratorFindParentUserTasks((FlowElement)source.getSubProcess(), hasSequenceFlow, userTaskList);
        }
        if ((sequenceFlows = FlowableUtils.getElementIncomingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                List<UserTask> childUserTaskList;
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (sequenceFlow.getSourceFlowElement() instanceof UserTask) {
                    userTaskList.add((UserTask)sequenceFlow.getSourceFlowElement());
                    continue;
                }
                if (sequenceFlow.getSourceFlowElement() instanceof SubProcess && (childUserTaskList = FlowableUtils.findChildProcessUserTasks((FlowElement)((StartEvent)((SubProcess)sequenceFlow.getSourceFlowElement()).getFlowElements().toArray()[0]), null, null)) != null && childUserTaskList.size() > 0) {
                    userTaskList.addAll(childUserTaskList);
                    continue;
                }
                userTaskList = FlowableUtils.iteratorFindParentUserTasks(sequenceFlow.getSourceFlowElement(), hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    public static List<UserTask> iteratorFindChildUserTasks(FlowElement source, List<String> runTaskKeyList, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        List<SequenceFlow> sequenceFlows;
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        List<UserTask> list = userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            userTaskList = FlowableUtils.iteratorFindChildUserTasks((FlowElement)source.getSubProcess(), runTaskKeyList, hasSequenceFlow, userTaskList);
        }
        if ((sequenceFlows = FlowableUtils.getElementOutgoingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                List<UserTask> childUserTaskList;
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (sequenceFlow.getTargetFlowElement() instanceof UserTask && runTaskKeyList.contains(sequenceFlow.getTargetFlowElement().getId())) {
                    userTaskList.add((UserTask)sequenceFlow.getTargetFlowElement());
                    continue;
                }
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess && (childUserTaskList = FlowableUtils.iteratorFindChildUserTasks((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], runTaskKeyList, hasSequenceFlow, null)) != null && childUserTaskList.size() > 0) {
                    userTaskList.addAll(childUserTaskList);
                    continue;
                }
                userTaskList = FlowableUtils.iteratorFindChildUserTasks(sequenceFlow.getTargetFlowElement(), runTaskKeyList, hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    public static List<UserTask> findChildProcessUserTasks(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        userTaskList = userTaskList == null ? new ArrayList<UserTask>() : userTaskList;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                List<UserTask> childUserTaskList;
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (sequenceFlow.getTargetFlowElement() instanceof UserTask) {
                    userTaskList.add((UserTask)sequenceFlow.getTargetFlowElement());
                    continue;
                }
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess && (childUserTaskList = FlowableUtils.findChildProcessUserTasks((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, null)) != null && childUserTaskList.size() > 0) {
                    userTaskList.addAll(childUserTaskList);
                    continue;
                }
                userTaskList = FlowableUtils.findChildProcessUserTasks(sequenceFlow.getTargetFlowElement(), hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    public static Set<String> iteratorFindDirtyRoads(FlowElement source, List<String> passRoads, Set<String> hasSequenceFlow, List<String> targets, Set<String> dirtyRoads) {
        List<SequenceFlow> sequenceFlows;
        passRoads = passRoads == null ? new ArrayList<String>() : passRoads;
        dirtyRoads = dirtyRoads == null ? new HashSet<String>() : dirtyRoads;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            dirtyRoads = FlowableUtils.iteratorFindDirtyRoads((FlowElement)source.getSubProcess(), passRoads, hasSequenceFlow, targets, dirtyRoads);
        }
        if ((sequenceFlows = FlowableUtils.getElementIncomingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                passRoads.add(sequenceFlow.getSourceFlowElement().getId());
                if (targets.contains(sequenceFlow.getSourceFlowElement().getId())) {
                    dirtyRoads.addAll(passRoads);
                    continue;
                }
                if (sequenceFlow.getSourceFlowElement() instanceof SubProcess) {
                    dirtyRoads = FlowableUtils.findChildProcessAllDirtyRoad((FlowElement)((StartEvent)((SubProcess)sequenceFlow.getSourceFlowElement()).getFlowElements().toArray()[0]), null, dirtyRoads);
                    Boolean isInChildProcess = FlowableUtils.dirtyTargetInChildProcess((FlowElement)((StartEvent)((SubProcess)sequenceFlow.getSourceFlowElement()).getFlowElements().toArray()[0]), null, targets, null);
                    if (isInChildProcess.booleanValue()) continue;
                }
                dirtyRoads = FlowableUtils.iteratorFindDirtyRoads(sequenceFlow.getSourceFlowElement(), passRoads, hasSequenceFlow, targets, dirtyRoads);
            }
        }
        return dirtyRoads;
    }

    public static Set<String> findChildProcessAllDirtyRoad(FlowElement source, Set<String> hasSequenceFlow, Set<String> dirtyRoads) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        dirtyRoads = dirtyRoads == null ? new HashSet<String>() : dirtyRoads;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                dirtyRoads.add(sequenceFlow.getTargetFlowElement().getId());
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess) {
                    dirtyRoads = FlowableUtils.findChildProcessAllDirtyRoad((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, dirtyRoads);
                }
                dirtyRoads = FlowableUtils.findChildProcessAllDirtyRoad(sequenceFlow.getTargetFlowElement(), hasSequenceFlow, dirtyRoads);
            }
        }
        return dirtyRoads;
    }

    public static Boolean dirtyTargetInChildProcess(FlowElement source, Set<String> hasSequenceFlow, List<String> targets, Boolean inChildProcess) {
        hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        inChildProcess = inChildProcess == null ? false : inChildProcess;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null && !inChildProcess.booleanValue()) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (targets.contains(sequenceFlow.getTargetFlowElement().getId())) {
                    inChildProcess = true;
                    break;
                }
                if (sequenceFlow.getTargetFlowElement() instanceof SubProcess) {
                    inChildProcess = FlowableUtils.dirtyTargetInChildProcess((FlowElement)((SubProcess)sequenceFlow.getTargetFlowElement()).getFlowElements().toArray()[0], hasSequenceFlow, targets, inChildProcess);
                }
                inChildProcess = FlowableUtils.dirtyTargetInChildProcess(sequenceFlow.getTargetFlowElement(), hasSequenceFlow, targets, inChildProcess);
            }
        }
        return inChildProcess;
    }

    public static Boolean iteratorCheckSequentialReferTarget(FlowElement source, String targetKsy, Set<String> hasSequenceFlow, Boolean isSequential) {
        List<SequenceFlow> sequenceFlows;
        isSequential = isSequential == null ? true : isSequential;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            isSequential = FlowableUtils.iteratorCheckSequentialReferTarget((FlowElement)source.getSubProcess(), targetKsy, hasSequenceFlow, isSequential);
        }
        if ((sequenceFlows = FlowableUtils.getElementIncomingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (!isSequential.booleanValue()) break;
                if (targetKsy.equals(sequenceFlow.getSourceFlowElement().getId())) continue;
                if (sequenceFlow.getSourceFlowElement() instanceof StartEvent) {
                    isSequential = false;
                    break;
                }
                isSequential = FlowableUtils.iteratorCheckSequentialReferTarget(sequenceFlow.getSourceFlowElement(), targetKsy, hasSequenceFlow, isSequential);
            }
        }
        return isSequential;
    }

    public static List<List<UserTask>> findRoad(FlowElement source, List<UserTask> passRoads, Set<String> hasSequenceFlow, List<List<UserTask>> roads) {
        List<SequenceFlow> sequenceFlows;
        passRoads = passRoads == null ? new ArrayList<UserTask>() : passRoads;
        roads = roads == null ? new ArrayList<List<UserTask>>() : roads;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            roads = FlowableUtils.findRoad((FlowElement)source.getSubProcess(), passRoads, hasSequenceFlow, roads);
        }
        if ((sequenceFlows = FlowableUtils.getElementIncomingFlows(source)) != null && sequenceFlows.size() != 0) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                if (sequenceFlow.getSourceFlowElement() instanceof UserTask) {
                    passRoads.add((UserTask)sequenceFlow.getSourceFlowElement());
                }
                roads = FlowableUtils.findRoad(sequenceFlow.getSourceFlowElement(), passRoads, hasSequenceFlow, roads);
            }
        } else {
            roads.add(passRoads);
        }
        return roads;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> historicTaskInstanceClean(Collection<FlowElement> allElements, List<HistoricTaskInstance> historicTaskInstanceList) {
        ArrayList multiTask = new ArrayList();
        allElements.forEach(flowElement -> {
            if (flowElement instanceof UserTask && (((UserTask)flowElement).getBehavior() instanceof ParallelMultiInstanceBehavior || ((UserTask)flowElement).getBehavior() instanceof SequentialMultiInstanceBehavior)) {
                multiTask.add(flowElement.getId());
            }
        });
        Stack stack = new Stack();
        historicTaskInstanceList.forEach(item -> stack.push(item));
        ArrayList<String> lastHistoricTaskInstanceList = new ArrayList<String>();
        StringBuilder userTaskKey = null;
        ArrayList<String> deleteKeyList = new ArrayList<String>();
        ArrayList<Set<String>> dirtyDataLineList = new ArrayList<Set<String>>();
        int multiIndex = -1;
        StringBuilder multiKey = null;
        boolean multiOpera = false;
        while (!stack.empty()) {
            boolean[] isDirtyData = new boolean[]{false};
            for (Set set : dirtyDataLineList) {
                if (!set.contains(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey())) continue;
                isDirtyData[0] = true;
            }
            if (((HistoricTaskInstance)stack.peek()).getDeleteReason() != null && !((HistoricTaskInstance)stack.peek()).getDeleteReason().equals("MI_END")) {
                void var13_17;
                String dirtyPoint = "";
                if (((HistoricTaskInstance)stack.peek()).getDeleteReason().indexOf("Change activity to ") >= 0) {
                    dirtyPoint = ((HistoricTaskInstance)stack.peek()).getDeleteReason().replace("Change activity to ", "");
                }
                if (((HistoricTaskInstance)stack.peek()).getDeleteReason().indexOf("Change parent activity to ") >= 0) {
                    dirtyPoint = ((HistoricTaskInstance)stack.peek()).getDeleteReason().replace("Change parent activity to ", "");
                }
                Object var13_16 = null;
                for (FlowElement flowElement2 : allElements) {
                    if (!flowElement2.getId().equals(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey())) continue;
                    FlowElement flowElement3 = flowElement2;
                }
                Set<String> dirtyDataLine = FlowableUtils.iteratorFindDirtyRoads((FlowElement)var13_17, null, null, Arrays.asList(dirtyPoint.split(",")), null);
                dirtyDataLine.add(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey());
                log.info(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey() + "\u70b9\u810f\u8def\u7ebf\u96c6\u5408\uff1a" + dirtyDataLine);
                boolean isNewDirtyData = true;
                for (int i = 0; i < dirtyDataLineList.size(); ++i) {
                    if (!((Set)dirtyDataLineList.get(i)).contains(userTaskKey.toString())) continue;
                    isNewDirtyData = false;
                    ((Set)dirtyDataLineList.get(i)).addAll(dirtyDataLine);
                }
                if (isNewDirtyData) {
                    deleteKeyList.add(dirtyPoint + ",");
                    dirtyDataLineList.add(dirtyDataLine);
                }
                isDirtyData[0] = true;
            }
            if (!isDirtyData[0]) {
                lastHistoricTaskInstanceList.add(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey());
            }
            for (int i = 0; i < deleteKeyList.size(); ++i) {
                if (multiKey == null && multiTask.contains(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey()) && ((String)deleteKeyList.get(i)).contains(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey())) {
                    multiIndex = i;
                    multiKey = new StringBuilder(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey());
                }
                if (multiKey != null && !multiKey.toString().equals(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey())) {
                    deleteKeyList.set(multiIndex, ((String)deleteKeyList.get(multiIndex)).replace(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey() + ",", ""));
                    multiKey = null;
                    multiOpera = true;
                }
                if (multiKey == null && ((String)deleteKeyList.get(i)).contains(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey())) {
                    deleteKeyList.set(i, ((String)deleteKeyList.get(i)).replace(((HistoricTaskInstance)stack.peek()).getTaskDefinitionKey() + ",", ""));
                }
                if (!"".equals(deleteKeyList.get(i))) continue;
                deleteKeyList.remove(i);
                dirtyDataLineList.remove(i);
                break;
            }
            if (multiOpera && deleteKeyList.size() > multiIndex && "".equals(deleteKeyList.get(multiIndex))) {
                deleteKeyList.remove(multiIndex);
                dirtyDataLineList.remove(multiIndex);
                multiIndex = -1;
                multiOpera = false;
            }
            userTaskKey = new StringBuilder(((HistoricTaskInstance)stack.pop()).getTaskDefinitionKey());
        }
        log.info("\u6e05\u6d17\u540e\u7684\u5386\u53f2\u8282\u70b9\u6570\u636e\uff1a" + lastHistoricTaskInstanceList);
        return lastHistoricTaskInstanceList;
    }

    public static Set<String> dfsFindRejects(BpmnModel bpmnModel, Set<String> unfinishedTaskSet, Set<String> finishedSequenceFlowSet, Set<String> finishedTaskSet) {
        if (ObjectUtil.isNull((Object)bpmnModel)) {
            throw new ServiceException("\u6d41\u7a0b\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        Collection<FlowElement> allElements = FlowableUtils.getAllElements(bpmnModel.getMainProcess().getFlowElements(), null);
        HashSet<String> rejectedSet = new HashSet<String>();
        for (FlowElement flowElement : allElements) {
            if (!(flowElement instanceof UserTask) || !unfinishedTaskSet.contains(flowElement.getId())) continue;
            List<String> hasSequenceFlow = FlowableUtils.iteratorFindFinishes(flowElement, null);
            List<String> rejects = FlowableUtils.iteratorFindRejects(flowElement, finishedSequenceFlowSet, finishedTaskSet, hasSequenceFlow, null);
            rejectedSet.addAll(rejects);
        }
        return rejectedSet;
    }

    public static List<String> iteratorFindFinishes(FlowElement source, List<String> hasSequenceFlow) {
        hasSequenceFlow = hasSequenceFlow == null ? new ArrayList<String>() : hasSequenceFlow;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementIncomingFlows(source);
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                FlowElement finishedElement = sequenceFlow.getSourceFlowElement();
                if (finishedElement instanceof SubProcess) {
                    StartEvent firstElement = (StartEvent)((SubProcess)finishedElement).getFlowElements().toArray()[0];
                    hasSequenceFlow.addAll(FlowableUtils.iteratorFindFinishes((FlowElement)firstElement, null));
                }
                hasSequenceFlow = FlowableUtils.iteratorFindFinishes(finishedElement, hasSequenceFlow);
            }
        }
        return hasSequenceFlow;
    }

    public static List<String> iteratorFindRejects(FlowElement source, Set<String> finishedSequenceFlowSet, Set<String> finishedTaskSet, List<String> hasSequenceFlow, List<String> rejectedList) {
        hasSequenceFlow = hasSequenceFlow == null ? new ArrayList<String>() : hasSequenceFlow;
        rejectedList = rejectedList == null ? new ArrayList<String>() : rejectedList;
        List<SequenceFlow> sequenceFlows = FlowableUtils.getElementOutgoingFlows(source);
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                FlowElement firstElement;
                List<String> childList;
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                FlowElement targetElement = sequenceFlow.getTargetFlowElement();
                if (finishedTaskSet.contains(targetElement.getId())) {
                    rejectedList.add(targetElement.getId());
                }
                if (finishedSequenceFlowSet.contains(sequenceFlow.getId())) {
                    rejectedList.add(sequenceFlow.getId());
                }
                if (targetElement instanceof SubProcess && (childList = FlowableUtils.iteratorFindRejects(firstElement = (FlowElement)((SubProcess)targetElement).getFlowElements().toArray()[0], finishedSequenceFlowSet, finishedTaskSet, hasSequenceFlow, null)) != null && childList.size() > 0) {
                    rejectedList.addAll(childList);
                    continue;
                }
                rejectedList = FlowableUtils.iteratorFindRejects(targetElement, finishedSequenceFlowSet, finishedTaskSet, hasSequenceFlow, rejectedList);
            }
        }
        return rejectedList;
    }
}

