/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.flowable.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.util.io.StringStreamSource;

public class ModelUtils {
    private static final BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();

    public static BpmnModel getBpmnModel(String xml) {
        return bpmnXMLConverter.convertToBpmnModel((InputStreamProvider)new StringStreamSource(xml), false, false);
    }

    @Deprecated
    public static String getBpmnXmlStr(BpmnModel bpmnModel) {
        return StrUtil.utf8Str((Object)ModelUtils.getBpmnXml(bpmnModel));
    }

    @Deprecated
    public static byte[] getBpmnXml(BpmnModel bpmnModel) {
        return bpmnXMLConverter.convertToXML(bpmnModel);
    }

    public static List<SequenceFlow> getElementIncomingFlows(FlowElement source) {
        List<Object> sequenceFlows = new ArrayList<SequenceFlow>();
        if (source instanceof FlowNode) {
            sequenceFlows = ((FlowNode)source).getIncomingFlows();
        }
        return sequenceFlows;
    }

    public static List<SequenceFlow> getElementOutgoingFlows(FlowElement source) {
        List<Object> sequenceFlows = new ArrayList<SequenceFlow>();
        if (source instanceof FlowNode) {
            sequenceFlows = ((FlowNode)source).getOutgoingFlows();
        }
        return sequenceFlows;
    }

    public static StartEvent getStartEvent(BpmnModel model) {
        Process process = model.getMainProcess();
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent) {
            return (StartEvent)startElement;
        }
        return ModelUtils.getStartEvent(process.getFlowElements());
    }

    public static StartEvent getStartEvent(Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            return (StartEvent)flowElement;
        }
        return null;
    }

    public static EndEvent getEndEvent(BpmnModel model) {
        Process process = model.getMainProcess();
        return ModelUtils.getEndEvent(process.getFlowElements());
    }

    public static EndEvent getEndEvent(Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof EndEvent)) continue;
            return (EndEvent)flowElement;
        }
        return null;
    }

    public static UserTask getUserTaskByKey(BpmnModel model, String taskKey) {
        Process process = model.getMainProcess();
        FlowElement flowElement = process.getFlowElement(taskKey);
        if (flowElement instanceof UserTask) {
            return (UserTask)flowElement;
        }
        return null;
    }

    public static FlowElement getFlowElementById(BpmnModel model, String flowElementId) {
        Process process = model.getMainProcess();
        return process.getFlowElement(flowElementId);
    }

    public static String getFormKey(FlowElement flowElement) {
        if (flowElement != null) {
            if (flowElement instanceof StartEvent) {
                return ((StartEvent)flowElement).getFormKey();
            }
            if (flowElement instanceof UserTask) {
                return ((UserTask)flowElement).getFormKey();
            }
        }
        return null;
    }

    public static String getStartEventAttributeValue(BpmnModel model, String name) {
        StartEvent startEvent = ModelUtils.getStartEvent(model);
        return ModelUtils.getElementAttributeValue((BaseElement)startEvent, name);
    }

    public static String getEndEventAttributeValue(BpmnModel model, String name) {
        EndEvent endEvent = ModelUtils.getEndEvent(model);
        return ModelUtils.getElementAttributeValue((BaseElement)endEvent, name);
    }

    public static String getUserTaskAttributeValue(BpmnModel model, String taskKey, String name) {
        UserTask userTask = ModelUtils.getUserTaskByKey(model, taskKey);
        return ModelUtils.getElementAttributeValue((BaseElement)userTask, name);
    }

    public static String getElementAttributeValue(BaseElement baseElement, String name) {
        List attributes;
        if (baseElement != null && (attributes = (List)baseElement.getAttributes().get(name)) != null && !attributes.isEmpty()) {
            ((ExtensionAttribute)attributes.iterator().next()).getValue();
            Iterator attrIterator = attributes.iterator();
            if (attrIterator.hasNext()) {
                ExtensionAttribute attribute = (ExtensionAttribute)attrIterator.next();
                return attribute.getValue();
            }
        }
        return null;
    }

    public static boolean isMultiInstance(BpmnModel model, String taskKey) {
        UserTask userTask = ModelUtils.getUserTaskByKey(model, taskKey);
        if (ObjectUtil.isNotNull((Object)userTask)) {
            return userTask.hasMultiInstanceLoopCharacteristics();
        }
        return false;
    }

    public static Collection<UserTask> getAllUserTaskEvent(BpmnModel model) {
        Process process = model.getMainProcess();
        Collection flowElements = process.getFlowElements();
        return ModelUtils.getAllUserTaskEvent(flowElements, null);
    }

    public static Collection<UserTask> getAllUserTaskEvent(Collection<FlowElement> flowElements, Collection<UserTask> allElements) {
        allElements = allElements == null ? new ArrayList<UserTask>() : allElements;
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof UserTask) {
                allElements.add((UserTask)flowElement);
            }
            if (!(flowElement instanceof SubProcess)) continue;
            allElements = ModelUtils.getAllUserTaskEvent(((SubProcess)flowElement).getFlowElements(), allElements);
        }
        return allElements;
    }

    public static List<UserTask> findNextUserTasks(FlowElement source) {
        return ModelUtils.findNextUserTasks(source, null, null);
    }

    public static List<UserTask> findNextUserTasks(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        hasSequenceFlow = Optional.ofNullable(hasSequenceFlow).orElse(new HashSet());
        userTaskList = Optional.ofNullable(userTaskList).orElse(new ArrayList());
        List<SequenceFlow> sequenceFlows = ModelUtils.getElementOutgoingFlows(source);
        if (!sequenceFlows.isEmpty()) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
                if (targetFlowElement instanceof UserTask) {
                    userTaskList.add((UserTask)targetFlowElement);
                    continue;
                }
                ModelUtils.findNextUserTasks(targetFlowElement, hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    public static boolean isSequentialReachable(FlowElement source, FlowElement target, Set<String> visitedElements) {
        HashSet<String> hashSet = visitedElements = visitedElements == null ? new HashSet<String>() : visitedElements;
        if (source instanceof StartEvent && ModelUtils.isInEventSubprocess(source)) {
            return false;
        }
        List<SequenceFlow> sequenceFlows = ModelUtils.getElementIncomingFlows(source);
        if (sequenceFlows != null && sequenceFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (visitedElements.contains(sequenceFlow.getId())) continue;
                visitedElements.add(sequenceFlow.getId());
                FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
                if (target.getId().equals(sourceFlowElement.getId())) continue;
                if (sourceFlowElement instanceof ParallelGateway) {
                    return false;
                }
                boolean isSequential = ModelUtils.isSequentialReachable(sourceFlowElement, target, visitedElements);
                if (isSequential) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean isInEventSubprocess(FlowElement flowElement) {
        FlowElementsContainer flowElementsContainer = flowElement.getParentContainer();
        while (flowElementsContainer != null) {
            if (flowElementsContainer instanceof EventSubProcess) {
                return true;
            }
            if (flowElementsContainer instanceof FlowElement) {
                flowElementsContainer = ((FlowElement)flowElementsContainer).getParentContainer();
                continue;
            }
            flowElementsContainer = null;
        }
        return false;
    }
}

