/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.flowable.flow;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.task.api.Task;

public class FindNextNodeUtil {
    public static List<UserTask> getNextUserTasks(RepositoryService repositoryService, Task task, Map<String, Object> map) {
        ArrayList<UserTask> data = new ArrayList<UserTask>();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinition.getId());
        Process mainProcess = bpmnModel.getMainProcess();
        Collection flowElements = mainProcess.getFlowElements();
        String key = task.getTaskDefinitionKey();
        FlowElement flowElement = bpmnModel.getFlowElement(key);
        FindNextNodeUtil.next(flowElements, flowElement, map, data);
        return data;
    }

    public static void next(Collection<FlowElement> flowElements, FlowElement flowElement, Map<String, Object> map, List<UserTask> nextUser) {
        if (flowElement instanceof EndEvent && FindNextNodeUtil.getSubProcess(flowElements, flowElement) != null) {
            flowElement = FindNextNodeUtil.getSubProcess(flowElements, flowElement);
        }
        List outGoingFlows = null;
        if (flowElement instanceof org.flowable.bpmn.model.Task) {
            outGoingFlows = ((org.flowable.bpmn.model.Task)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof Gateway) {
            outGoingFlows = ((Gateway)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof StartEvent) {
            outGoingFlows = ((StartEvent)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof SubProcess) {
            outGoingFlows = ((SubProcess)flowElement).getOutgoingFlows();
        } else if (flowElement instanceof CallActivity) {
            outGoingFlows = ((CallActivity)flowElement).getOutgoingFlows();
        }
        if (outGoingFlows != null && outGoingFlows.size() > 0) {
            for (SequenceFlow sequenceFlow : outGoingFlows) {
                String nextFlowElementID;
                String expression = sequenceFlow.getConditionExpression();
                if (expression != null && !FindNextNodeUtil.expressionResult(map, expression.substring(expression.lastIndexOf("{") + 1, expression.lastIndexOf("}"))) || FindNextNodeUtil.checkSubProcess(nextFlowElementID = sequenceFlow.getTargetRef(), flowElements, nextUser)) continue;
                FlowElement nextFlowElement = FindNextNodeUtil.getFlowElementById(nextFlowElementID, flowElements);
                if (nextFlowElement instanceof CallActivity) {
                    CallActivity ca = (CallActivity)nextFlowElement;
                    if (ca.getLoopCharacteristics() != null) {
                        UserTask userTask = new UserTask();
                        userTask.setId(ca.getId());
                        userTask.setId(ca.getId());
                        userTask.setLoopCharacteristics(ca.getLoopCharacteristics());
                        userTask.setName(ca.getName());
                        nextUser.add(userTask);
                    }
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                }
                if (nextFlowElement instanceof UserTask) {
                    nextUser.add((UserTask)nextFlowElement);
                    continue;
                }
                if (nextFlowElement instanceof ExclusiveGateway) {
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                    continue;
                }
                if (nextFlowElement instanceof ParallelGateway) {
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                    continue;
                }
                if (nextFlowElement instanceof ReceiveTask) {
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                    continue;
                }
                if (nextFlowElement instanceof ServiceTask) {
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                    continue;
                }
                if (nextFlowElement instanceof StartEvent) {
                    FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
                    continue;
                }
                if (!(nextFlowElement instanceof EndEvent)) continue;
                FindNextNodeUtil.next(flowElements, nextFlowElement, map, nextUser);
            }
        }
    }

    public static boolean checkSubProcess(String Id, Collection<FlowElement> flowElements, List<UserTask> nextUser) {
        for (FlowElement flowElement1 : flowElements) {
            SubProcess sp;
            if (!(flowElement1 instanceof SubProcess) || !flowElement1.getId().equals(Id) || (sp = (SubProcess)flowElement1).getLoopCharacteristics() == null) continue;
            String inputDataItem = sp.getLoopCharacteristics().getInputDataItem();
            UserTask userTask = new UserTask();
            userTask.setId(sp.getId());
            userTask.setLoopCharacteristics(sp.getLoopCharacteristics());
            userTask.setName(sp.getName());
            nextUser.add(userTask);
            return true;
        }
        return false;
    }

    public static FlowElement getSubProcess(Collection<FlowElement> flowElements, FlowElement flowElement) {
        for (FlowElement flowElement1 : flowElements) {
            if (!(flowElement1 instanceof SubProcess)) continue;
            for (FlowElement flowElement2 : ((SubProcess)flowElement1).getFlowElements()) {
                if (!flowElement.equals(flowElement2)) continue;
                return flowElement1;
            }
        }
        return null;
    }

    public static FlowElement getFlowElementById(String Id, Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            FlowElement flowElement1;
            if (flowElement.getId().equals(Id)) {
                if (flowElement instanceof SubProcess) {
                    return FindNextNodeUtil.getStartFlowElement(((SubProcess)flowElement).getFlowElements());
                }
                return flowElement;
            }
            if (!(flowElement instanceof SubProcess) || (flowElement1 = FindNextNodeUtil.getFlowElementById(Id, ((SubProcess)flowElement).getFlowElements())) == null) continue;
            return flowElement1;
        }
        return null;
    }

    public static FlowElement getStartFlowElement(Collection<FlowElement> flowElements) {
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            return flowElement;
        }
        return null;
    }

    public static boolean expressionResult(Map<String, Object> map, String expression) {
        Expression exp = AviatorEvaluator.compile((String)expression);
        Object execute = exp.execute(map);
        return Boolean.parseBoolean(String.valueOf(execute));
    }
}

