/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.flowable.utils;

import cn.hutool.core.date.DateUtil;
import cn.jrack.core.util.common.StringUtil;
import cn.jrack.flowable.core.domain.ProcessQuery;
import java.util.Date;
import java.util.Map;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;

public class ProcessUtils {
    public static void buildProcessSearch(Query<?, ?> query, ProcessQuery process) {
        if (query instanceof ProcessDefinitionQuery) {
            ProcessUtils.buildProcessDefinitionSearch((ProcessDefinitionQuery)query, process);
        } else if (query instanceof TaskQuery) {
            ProcessUtils.buildTaskSearch((TaskQuery)query, process);
        } else if (query instanceof HistoricTaskInstanceQuery) {
            ProcessUtils.buildHistoricTaskInstanceSearch((HistoricTaskInstanceQuery)query, process);
        } else if (query instanceof HistoricProcessInstanceQuery) {
            ProcessUtils.buildHistoricProcessInstanceSearch((HistoricProcessInstanceQuery)query, process);
        }
    }

    public static void buildProcessDefinitionSearch(ProcessDefinitionQuery query, ProcessQuery process) {
        if (StringUtil.isNotBlank((CharSequence)process.getProcessKey())) {
            query.processDefinitionKeyLike("%" + process.getProcessKey() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)process.getProcessName())) {
            query.processDefinitionNameLike("%" + process.getProcessName() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)process.getCategory())) {
            query.processDefinitionCategory(process.getCategory());
        }
        if (StringUtil.isNotBlank((CharSequence)process.getState())) {
            if (SuspensionState.ACTIVE.toString().equals(process.getState())) {
                query.active();
            } else if (SuspensionState.SUSPENDED.toString().equals(process.getState())) {
                query.suspended();
            }
        }
    }

    public static void buildTaskSearch(TaskQuery query, ProcessQuery process) {
        Map<String, Object> params = process.getParams();
        if (StringUtil.isNotBlank((CharSequence)process.getProcessKey())) {
            query.processDefinitionKeyLike("%" + process.getProcessKey() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)process.getProcessName())) {
            query.processDefinitionNameLike("%" + process.getProcessName() + "%");
        }
        if (params.get("beginTime") != null && params.get("endTime") != null) {
            query.taskCreatedAfter((Date)DateUtil.parseDate((CharSequence)params.get("beginTime").toString()));
            query.taskCreatedBefore((Date)DateUtil.parseDate((CharSequence)params.get("endTime").toString()));
        }
    }

    private static void buildHistoricTaskInstanceSearch(HistoricTaskInstanceQuery query, ProcessQuery process) {
        Map<String, Object> params = process.getParams();
        if (StringUtil.isNotBlank((CharSequence)process.getProcessKey())) {
            query.processDefinitionKeyLike("%" + process.getProcessKey() + "%");
        }
        if (StringUtil.isNotBlank((CharSequence)process.getProcessName())) {
            query.processDefinitionNameLike("%" + process.getProcessName() + "%");
        }
        if (params.get("beginTime") != null && params.get("endTime") != null) {
            query.taskCompletedAfter((Date)DateUtil.parseDate((CharSequence)params.get("beginTime").toString()));
            query.taskCompletedBefore((Date)DateUtil.parseDate((CharSequence)params.get("endTime").toString()));
        }
    }

    public static void buildHistoricProcessInstanceSearch(HistoricProcessInstanceQuery query, ProcessQuery process) {
        Map<String, Object> params = process.getParams();
        if (StringUtil.isNotBlank((CharSequence)process.getProcessKey())) {
            query.processDefinitionKey(process.getProcessKey());
        }
        if (StringUtil.isNotBlank((CharSequence)process.getProcessName())) {
            query.processDefinitionName(process.getProcessName());
        }
        if (StringUtil.isNotBlank((CharSequence)process.getCategory())) {
            query.processDefinitionCategory(process.getCategory());
        }
        if (params.get("beginTime") != null && params.get("endTime") != null) {
            query.startedAfter((Date)DateUtil.parseDate((CharSequence)params.get("beginTime").toString()));
            query.startedBefore((Date)DateUtil.parseDate((CharSequence)params.get("endTime").toString()));
        }
    }
}

