/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.excel.core.handler;

import cn.jrack.core.util.common.StringUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

public class ExcelHandler {
    private List<List<String>> heads = new ArrayList<List<String>>();
    private String title;
    private List<List<Object>> data;
    private String sheetName = "sheet";
    private String fileName = "EXCEL";
    private String filePath;
    private int headIndex = 0;
    private WriteCellStyle headStyle;
    private WriteCellStyle contentStyle;
    private ExcelWriterBuilder excelWriterBuilder;
    private List<WriteHandler> writeHandlers = new ArrayList<WriteHandler>();

    public ExcelHandler() {
        this.data = new ArrayList<List<Object>>();
        this.headStyle = new WriteCellStyle();
        this.contentStyle = new WriteCellStyle();
        this.excelWriterBuilder = new ExcelWriterBuilder();
    }

    public ExcelHandler title(String title) {
        this.title = title;
        return this;
    }

    public ExcelHandler addRow(List<Object> list) {
        this.data.add(list);
        return this;
    }

    public ExcelHandler addRow(Object ... objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : objects) {
            list.add(o);
        }
        return this.addRow(list);
    }

    public ExcelHandler addHeads(List<List<String>> heads) {
        this.heads = heads;
        return this;
    }

    public ExcelHandler addHead(List<String> headCell) {
        if (headCell.size() > this.headIndex) {
            this.headIndex = headCell.size();
        }
        this.heads.add(headCell);
        return this;
    }

    public ExcelHandler addHead(String ... headName) {
        return this.addHead(ExcelHandler.buildHead(headName));
    }

    public ExcelHandler data(List<List<Object>> data) {
        if (this.data.size() > 0) {
            this.data.addAll(data);
        } else {
            this.data = data;
        }
        return this;
    }

    public ExcelHandler buildData(List list) {
        try {
            return this.data(ExcelHandler.convertToArrayList(list));
        }
        catch (IllegalAccessException illegalAccessException) {
            return this;
        }
    }

    public void doWrite(String filePath) throws IOException {
        this.filePath = filePath;
        this.doWrite();
    }

    public void doWrite() throws IOException {
        this.checkAttribute();
        if (!StringUtil.isEmpty((String)this.title)) {
            for (List<String> l : this.heads) {
                l.add(0, this.title);
            }
        }
        File file = new File(this.filePath);
        this.excelWriterBuilder = EasyExcel.write((File)file);
        for (WriteHandler writeHandler : this.writeHandlers) {
            this.excelWriterBuilder.registerWriteHandler(writeHandler);
        }
        this.excelWriterBuilder.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        this.excelWriterBuilder.head(this.heads);
        this.excelWriterBuilder.sheet(this.sheetName).doWrite(this.data);
    }

    public void doExport(HttpServletResponse response) throws IOException {
        if (!StringUtil.isEmpty((String)this.title)) {
            for (List<String> l : this.heads) {
                l.add(0, this.title);
            }
        }
        this.excelWriterBuilder = EasyExcel.write((OutputStream)response.getOutputStream());
        for (WriteHandler writeHandler : this.writeHandlers) {
            this.excelWriterBuilder.registerWriteHandler(writeHandler);
        }
        this.excelWriterBuilder.registerWriteHandler((WriteHandler)new HorizontalCellStyleStrategy(this.headStyle, this.contentStyle));
        ((ExcelWriterBuilder)this.excelWriterBuilder.head(this.heads)).autoCloseStream(Boolean.valueOf(false));
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(this.fileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        this.excelWriterBuilder.sheet(this.sheetName).doWrite(this.data);
    }

    public static List<String> buildHead(String ... label) {
        ArrayList<String> list = new ArrayList<String>();
        for (String l : label) {
            list.add(l);
        }
        return list;
    }

    public ExcelHandler registerWriteHandler(WriteHandler writeHandler) {
        this.writeHandlers.add(writeHandler);
        return this;
    }

    public ExcelHandler mergeCell(int firstRowIndex, int lastRowIndex, int firstColumnIndex, int lastColumnIndex) {
        OnceAbsoluteMergeStrategy onceAbsoluteMergeStrategy = new OnceAbsoluteMergeStrategy(firstRowIndex, lastRowIndex, firstColumnIndex, lastColumnIndex);
        return this.registerWriteHandler((WriteHandler)onceAbsoluteMergeStrategy);
    }

    public ExcelHandler headStyle(int fontHeightInPoints, IndexedColors fillForegroundColor, IndexedColors fontColor) {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(fillForegroundColor.getIndex()));
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)fontHeightInPoints));
        headWriteFont.setColor(Short.valueOf(fontColor.getIndex()));
        headWriteCellStyle.setWriteFont(headWriteFont);
        return this.headStyle(headWriteCellStyle);
    }

    public ExcelHandler headStyle(WriteCellStyle writeCellStyle) {
        this.headStyle = writeCellStyle;
        return this;
    }

    public ExcelHandler border(Boolean enableBorder) {
        if (enableBorder.booleanValue()) {
            WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
            BorderStyle borderStyle = BorderStyle.THIN;
            contentWriteCellStyle.setBorderRight(borderStyle);
            contentWriteCellStyle.setBorderBottom(borderStyle);
            contentWriteCellStyle.setBorderTop(borderStyle);
            contentWriteCellStyle.setBorderLeft(borderStyle);
            return this.contentStyle(contentWriteCellStyle);
        }
        return this;
    }

    public ExcelHandler contentStyle(int fontHeightInPoints, IndexedColors fillForegroundColor, IndexedColors fontColor) {
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        contentWriteCellStyle.setFillForegroundColor(Short.valueOf(fillForegroundColor.getIndex()));
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)fontHeightInPoints));
        contentWriteFont.setColor(Short.valueOf(fontColor.getIndex()));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        return this.contentStyle(contentWriteCellStyle);
    }

    public ExcelHandler contentStyle(WriteCellStyle writeCellStyle) {
        this.contentStyle = writeCellStyle;
        return this;
    }

    public ExcelHandler openLongestMatchColumnWidthStyleStrategy() {
        this.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        return this;
    }

    public ExcelHandler fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ExcelHandler sheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public ExcelHandler filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    private void checkAttribute() throws IOException {
        if (StringUtil.isEmpty((String)this.filePath)) {
            throw new IOException("filePath not set");
        }
    }

    private int computeRowSize() {
        int rn = this.headIndex + this.data.size();
        if (!StringUtil.isEmpty((String)this.title)) {
            ++rn;
        }
        return rn;
    }

    private int computeRowIndex() {
        return this.computeRowSize() - 1;
    }

    public static <T> List<List<Object>> convertToArrayList(List<T> list) throws IllegalAccessException {
        ArrayList<List<Object>> listArrayList = new ArrayList<List<Object>>();
        for (T t : list) {
            ArrayList<Object> objectList = new ArrayList<Object>();
            T cs = t;
            Field[] fields = cs.getClass().getDeclaredFields();
            int i = 0;
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(t);
                objectList.add(value);
            }
            listArrayList.add(objectList);
            ++i;
        }
        return listArrayList;
    }
}

