/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.excel.core.convert;

import cn.hutool.core.convert.Convert;
import cn.jrack.excel.core.annotation.DictFormat;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictConvert
implements Converter<Object> {
    private static final Logger log = LoggerFactory.getLogger(DictConvert.class);

    public Class<?> supportJavaTypeKey() {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\uff0c\u4e5f\u4e0d\u9700\u8981");
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\uff0c\u4e5f\u4e0d\u9700\u8981");
    }

    public Object convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String type = DictConvert.getType(contentProperty);
        String label = cellData.getStringValue();
        String value = "";
        if (value == null) {
            log.error("[convertToJavaData][type({}) \u89e3\u6790\u4e0d\u6389 label({})]", (Object)type, (Object)label);
            return null;
        }
        Class<?> fieldClazz = contentProperty.getField().getType();
        return Convert.convert(fieldClazz, (Object)value);
    }

    public WriteCellData<?> convertToExcelData(Object object, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (object == null) {
            return new WriteCellData("");
        }
        String type = DictConvert.getType(contentProperty);
        String value = String.valueOf(object);
        String label = "";
        if (label == null) {
            log.error("[convertToExcelData][type({}) \u8f6c\u6362\u4e0d\u4e86 label({})]", (Object)type, (Object)value);
            return new WriteCellData("");
        }
        return new WriteCellData(label);
    }

    private static String getType(ExcelContentProperty contentProperty) {
        return contentProperty.getField().getAnnotation(DictFormat.class).value();
    }
}

