package cn.jrack.excel.core.util;

import cn.jrack.core.util.common.FileUtil;
import cn.jrack.excel.core.handler.StringExcelListener;
import cn.jrack.excel.core.pojo.Excel;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;

/**
 * Excel 工具类
 */
public class ExcelUtil extends EasyExcelFactory {


    public static void exportExcel(Excel excel) throws IOException {

    }

    /**
     * 将列表以 Excel 响应给前端
     *
     * @param response  响应
     * @param filename  文件名
     * @param sheetName Excel sheet 名
     * @param head      Excel head 头
     * @param data      数据列表哦
     * @param <T>       泛型，保证 head 和 data 类型的一致性
     * @throws IOException 写入失败的情况
     */
    public static <T> void downloadExcel(HttpServletResponse response, String filename, String sheetName,
                                         Class<T> head, List<T> data) throws IOException {
        // 输出 Excel
        EasyExcel.write(response.getOutputStream(), head)
                .autoCloseStream(false) // 不要自动关闭，交给 Servlet 自己处理
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy()) // 基于 column 长度，自动适配。最大 255 宽度
                .sheet(sheetName).doWrite(data);
        // 设置 header 和 contentType。写在最后的原因是，避免报错时，响应 contentType 已经被修改了
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
    }

    public static <T> List<T> readExcel(MultipartFile file, Class<T> head) throws IOException {
        return EasyExcel.read(file.getInputStream(), head, null)
                .autoCloseStream(false)  // 不要自动关闭，交给 Servlet 自己处理
                .doReadAllSync();
    }

    public static <T> List<T> readExcel(File file, Class head) {
        return EasyExcel.read(file, head, null).doReadAllSync();
    }

    public static <T> List<T> readExcel(File file, Class head, ReadListener readListener) {
        return EasyExcel.read(file, head, readListener).doReadAllSync();
    }

    public static List<List<String>> readExcel(String path) {
        List<Object> list = null;
        Boolean exists = FileUtil.exists(path);
        File file = new File(path);
        StringExcelListener stringExcelListener = new StringExcelListener();
        EasyExcel.read(path, stringExcelListener);
        ExcelReader excelReader = EasyExcelFactory.read(path, null, stringExcelListener).headRowNumber(0).build();
        excelReader.read();
        List<List<String>> datas = stringExcelListener.getDatas();
        return datas;
    }


}
