/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.dict.core.serializer;

import cn.jrack.springboot.core.util.SpringUtil;
import cn.jrack.springboot.dict.core.annotation.Dictionary;
import cn.jrack.springboot.dict.core.entity.DictionaryEntity;
import cn.jrack.springboot.dict.core.handler.DictionaryHandler;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DictionarySerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    private String code;
    private String fieldName;
    private DictionaryHandler dictionaryHandler;
    private Map<String, List<DictionaryEntity>> listMap;

    @Autowired
    public void setUserServer(DictionaryHandler dictionaryHandler) {
        this.dictionaryHandler = dictionaryHandler;
        Collection valuesByBeanType = SpringUtil.getValuesByBeanType(DictionaryHandler.class);
        for (DictionaryHandler dh : valuesByBeanType) {
            this.listMap.putAll(dh.mount());
        }
    }

    public DictionarySerializer(String code, String fieldName) {
        this.code = code;
        this.fieldName = fieldName;
    }

    public DictionarySerializer() {
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(o);
        List<DictionaryEntity> dictionaryEntities = this.listMap.get(this.code);
        if (dictionaryEntities != null) {
            Boolean flag = false;
            Optional<DictionaryEntity> first = dictionaryEntities.stream().filter(item -> item.getValue().equals(o.toString())).findFirst();
            if (first.isPresent()) {
                flag = true;
                jsonGenerator.writeStringField(this.fieldName, first.get().getText());
            }
            if (!flag.booleanValue()) {
                jsonGenerator.writeStringField(this.fieldName, "");
            }
        } else {
            jsonGenerator.writeStringField(this.fieldName, "");
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            Dictionary t = (Dictionary)beanProperty.getAnnotation(Dictionary.class);
            if (t != null) {
                String beanFieldName = beanProperty.getName();
                if (StringUtils.hasText((String)t.name())) {
                    return new DictionarySerializer(t.code(), t.name());
                }
                return new DictionarySerializer(t.code(), beanFieldName + "Text");
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }
}

