/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.springboot.dict.config;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.jrack.springboot.dict.core.annotation.Dictionary;
import cn.jrack.springboot.dict.core.handler.DictionaryHandler;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

@Configuration
@ComponentScan(basePackages={"*"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value={DictionaryHandler.class})}, useDefaultFilters=false)
public class JrackDictAutoConfiguration {
    @Autowired
    private ResourceLoader resourceLoader;
    private static final String VALUE = "value";

    @Bean(value={"initDictionaryEnum"})
    public void initDictionaryEnum() {
        try {
            this.getAllAddTagAnnotationUrl("classpath*:**/*.class", Dictionary.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> Map<String, Object> getAllAddTagAnnotationUrl(String classPath, Class<T> tagAnnotationClass) throws Exception {
        Resource[] resources;
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
        CachingMetadataReaderFactory metaReader = new CachingMetadataReaderFactory(this.resourceLoader);
        for (Resource r : resources = resolver.getResources(classPath)) {
            String classname;
            Class<?> clazz;
            Enumeration<URL> resources1 = ClassUtil.getClassLoader().getResources(r.getFilename());
            MetadataReader reader = metaReader.getMetadataReader(r);
            AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
            Map annotationAttributes = annotationMetadata.getAnnotationAttributes(tagAnnotationClass.getCanonicalName());
            if (annotationAttributes == null || !(clazz = Class.forName(classname = reader.getClassMetadata().getClassName())).isEnum()) continue;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Enum[] enmus = (Enum[])clazz.getEnumConstants();
            int var3 = enmus.length;
            for (int i = 0; i < enmus.length; ++i) {
                Enum enmus1 = enmus[i];
                Object fieldValue = ReflectUtil.getFieldValue((Object)enmus1, (String)enmus[i].name());
                map.put(enmus[i].name(), "");
            }
            ?[] enumConstants = clazz.getEnumConstants();
            for (Object obj : clazz.getEnumConstants()) {
                System.out.println(obj);
            }
        }
        return resMap;
    }
}

