package cn.jrack.springboot.dict.core.annotation;

import cn.jrack.springboot.dict.core.serializer.DictionarySerializer;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *Dict
 *@author joy
 *@date 2023-05-23
 */
@Target({ElementType.FIELD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@JacksonAnnotationsInside
@JsonSerialize(using = DictionarySerializer.class)
public @interface Dictionary {
    String value() default "";

    /** 字典类型 */
    String code();

    String name() default "";

    boolean multiple() default false;
}
