package cn.jrack.springboot.dict.core.serializer;

import cn.jrack.springboot.dict.core.annotation.Dictionary;
import cn.jrack.springboot.dict.core.entity.DictionaryEntity;
import cn.jrack.springboot.dict.core.handler.DictionaryHandler;
import cn.jrack.springboot.core.util.SpringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

@Component
public class DictionarySerializer extends JsonSerializer<Object> implements ContextualSerializer {

    private String code;
    private String fieldName;


    private DictionaryHandler dictionaryHandler;


    private Map<String, List<DictionaryEntity>> listMap;

    @Autowired
    public void setUserServer(DictionaryHandler dictionaryHandler) {
        this.dictionaryHandler = dictionaryHandler;
        Collection<DictionaryHandler> valuesByBeanType = SpringUtil.getValuesByBeanType(DictionaryHandler.class);
        for (DictionaryHandler dh :
                valuesByBeanType) {
            listMap.putAll(dh.mount());
        }
    }


    /** 字典注解 */
    public DictionarySerializer(String code, String fieldName) {
        this.code = code;
        this.fieldName = fieldName;
    }


    public DictionarySerializer() {

    }

    @Override
    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeObject(o);

        //这一步是通过code和value获取name，根据自己框架获取哈，我这里只是模拟一个获取的方法


        List<DictionaryEntity> dictionaryEntities = listMap.get(this.code);
        if (dictionaryEntities != null) {

            Boolean flag = false;

            Optional<DictionaryEntity> first = dictionaryEntities.stream().filter(item -> item.getValue().equals(o.toString())).findFirst();
            if (first.isPresent()) {
                flag = true;
                jsonGenerator.writeStringField(fieldName, first.get().getText());

            }

            if (!flag) {
                jsonGenerator.writeStringField(fieldName, "");
            }


        } else {
            jsonGenerator.writeStringField(fieldName, "");
        }

    }


    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {

            Dictionary t = beanProperty.getAnnotation(Dictionary.class);
            if (t != null) {
                String beanFieldName = beanProperty.getName();
                if (StringUtils.hasText(t.name())) {
                    return new DictionarySerializer(t.code(), t.name());
                }
                return new DictionarySerializer(t.code(), beanFieldName + "Text");
            }

            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }
}