package cn.jrack.springboot.dict.config;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.jrack.springboot.dict.core.annotation.Dictionary;
import cn.jrack.springboot.dict.core.handler.DictionaryHandler;
import cn.jrack.springboot.core.util.SpringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 *DictConfigure
 *@author joy
 *@date 2023-05-23
 */
@Configuration
@ComponentScan(basePackages = {"*"},
        includeFilters = {@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, value = DictionaryHandler.class)}, useDefaultFilters = false
)
public class JrackDictAutoConfiguration {


    @Autowired
    private ResourceLoader resourceLoader;

    private static final String VALUE = "value";

    @Bean("initDictionaryEnum")
    public void initDictionaryEnum() {
        try {
            getAllAddTagAnnotationUrl("classpath*:**/*.class", Dictionary.class);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private <T> Map<String, Object> getAllAddTagAnnotationUrl(String classPath, Class<T> tagAnnotationClass) throws Exception {
        Map<String, Object> resMap = new HashMap<>();
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
        MetadataReaderFactory metaReader = new CachingMetadataReaderFactory(resourceLoader);
        Resource[] resources = resolver.getResources(classPath);

        for (org.springframework.core.io.Resource r : resources) {
            Enumeration<URL> resources1 = ClassUtil.getClassLoader().getResources(r.getFilename());
            MetadataReader reader = metaReader.getMetadataReader(r);
            //获取注解元数据
            AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
            //获取类中RequestMapping注解的属性
            Map<String, Object> annotationAttributes =
                    annotationMetadata.getAnnotationAttributes(tagAnnotationClass.getCanonicalName());


            //若类无RequestMapping注解
            if (annotationAttributes != null) {
                //扫描到的class
                String classname = reader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(classname);
                if(clazz.isEnum())
                {
                    LinkedHashMap<String, String> map = new LinkedHashMap();
                    Enum[] enmus = (Enum[])clazz.getEnumConstants();
                    int var3 = enmus.length;

                    for(int i = 0; i < enmus.length; ++i) {
                        Enum enmus1 = enmus[i];
                        Object fieldValue = ReflectUtil.getFieldValue(enmus1, enmus[i].name());

                        map.put(enmus[i].name(), "");
                    }



                    Object[] enumConstants = clazz.getEnumConstants();
                    for (Object obj : clazz.getEnumConstants()) {
                        System.out.println(obj);
                    }
                }


            }

        }


        return resMap;
    }
}
