/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util.servlet;

import cn.hutool.core.util.StrUtil;
import cn.jrack.core.constant.SystemConstant;
import cn.jrack.core.util.json.JsonUtil;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getResponse();
    }

    public static HttpSession getSession() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getRequest().getSession();
    }

    public static Boolean isAjax(HttpServletRequest request) {
        String requestType = request.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(requestType)) {
            return true;
        }
        return false;
    }

    public static void write(String msg) throws IOException {
        HttpServletResponse response = ServletUtil.getResponse();
        response.setHeader("Content-type", "application/json;charset=UTF-8");
        response.setCharacterEncoding(SystemConstant.UTF8);
        response.getWriter().write(msg);
    }

    public static String getQueryParam() {
        return ServletUtil.getRequest().getQueryString();
    }

    public static String getRequestURI() {
        return ServletUtil.getRequest().getRequestURI();
    }

    public static String getUserAgent(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        return ua != null ? ua : "";
    }

    public static String getRemoteHost() {
        String remoteHost = ServletUtil.getRequest().getRemoteHost();
        if (remoteHost.equals("0:0:0:0:0:0:0:1")) {
            remoteHost = "127.0.0.1";
        }
        return remoteHost;
    }

    public static String getMethod() {
        return ServletUtil.getRequest().getMethod();
    }

    public static String getHeader(String name) {
        return ServletUtil.getRequest().getHeader(name);
    }

    public static boolean isJsonRequest(ServletRequest request) {
        return StrUtil.startWithIgnoreCase((CharSequence)request.getContentType(), (CharSequence)"application/json");
    }

    public static void writeJson(HttpServletResponse response, Object object) {
        String content = JsonUtil.toJsonString(object);
        cn.hutool.extra.servlet.ServletUtil.write((HttpServletResponse)response, (String)content, (String)"application/json;charset=UTF-8");
    }

    public static String getAgent() {
        return ServletUtil.getHeader("User-Agent");
    }

    public static String getBrowser() {
        String userAgent = ServletUtil.getAgent();
        if (userAgent.contains("Firefox")) {
            return "\u706b\u72d0\u6d4f\u89c8\u5668";
        }
        if (userAgent.contains("Chrome")) {
            return "\u8c37\u6b4c\u6d4f\u89c8\u5668";
        }
        if (userAgent.contains("Trident")) {
            return "IE \u6d4f\u89c8\u5668";
        }
        return "\u672a\u77e5\u6d4f\u89c8\u5668";
    }

    public static String getSystem() {
        String userAgent = ServletUtil.getAgent();
        if (userAgent.toLowerCase().contains("windows")) {
            return "Windows";
        }
        if (userAgent.toLowerCase().contains("mac")) {
            return "Mac";
        }
        if (userAgent.toLowerCase().contains("x11")) {
            return "Unix";
        }
        if (userAgent.toLowerCase().contains("android")) {
            return "Android";
        }
        if (userAgent.toLowerCase().contains("iphone")) {
            return "IPhone";
        }
        return "UnKnown, More-Info: " + userAgent;
    }

    public static void writeJSON(HttpServletResponse response, Object object) {
        String content = JsonUtil.toJsonString(object);
        cn.hutool.extra.servlet.ServletUtil.write((HttpServletResponse)response, (String)content, (String)"application/json;charset=UTF-8");
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        return cn.hutool.extra.servlet.ServletUtil.getClientIP((HttpServletRequest)request, (String[])otherHeaderNames);
    }
}

