/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util;

import cn.jrack.core.util.json.JsonUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    private static volatile OkHttpClient okHttpClient = null;
    private static volatile Semaphore semaphore = null;
    private Map<String, String> headerMap;
    private Map<String, Object> paramMap;
    private Object data;
    private String url;
    private Request.Builder request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OkHttpUtil() {
        if (okHttpClient != null) return;
        Class<OkHttpUtil> clazz = OkHttpUtil.class;
        synchronized (OkHttpUtil.class) {
            if (okHttpClient != null) return;
            TrustManager[] trustManagers = OkHttpUtil.buildTrustManagers();
            okHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).sslSocketFactory(OkHttpUtil.createSSLSocketFactory(trustManagers), (X509TrustManager)trustManagers[0]).hostnameVerifier((hostName, session) -> true).retryOnConnectionFailure(true).build();
            this.addHeader("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Semaphore getSemaphoreInstance() {
        Class<OkHttpUtil> clazz = OkHttpUtil.class;
        synchronized (OkHttpUtil.class) {
            if (semaphore == null) {
                semaphore = new Semaphore(0);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return semaphore;
        }
    }

    public static OkHttpUtil builder() {
        return new OkHttpUtil();
    }

    public OkHttpUtil url(String url) {
        this.url = url;
        return this;
    }

    public OkHttpUtil addParam(String key, Object value) {
        if (this.paramMap == null) {
            this.paramMap = new LinkedHashMap<String, Object>(16);
        }
        this.paramMap.put(key, value);
        return this;
    }

    public OkHttpUtil addParams(LinkedHashMap<String, Object> parmas) {
        if (parmas == null) {
            this.paramMap = new LinkedHashMap<String, Object>(16);
        }
        this.paramMap = parmas;
        return this;
    }

    public OkHttpUtil addData(Object data) {
        this.data = data;
        return this;
    }

    public OkHttpUtil addHeader(String key, String value) {
        if (this.headerMap == null) {
            this.headerMap = new LinkedHashMap<String, String>(16);
        }
        this.headerMap.put(key, value);
        return this;
    }

    public OkHttpUtil get() {
        this.request = new Request.Builder().get();
        StringBuilder urlBuilder = new StringBuilder(this.url);
        if (this.paramMap != null) {
            urlBuilder.append("?");
            try {
                for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
                    if (entry.getValue().equals(null)) continue;
                    urlBuilder.append(URLEncoder.encode(entry.getKey(), "utf-8")).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "utf-8")).append("&");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
        this.request.url(urlBuilder.toString());
        return this;
    }

    public OkHttpUtil post(boolean isJsonPost) {
        FormBody requestBody;
        if (isJsonPost) {
            String json = "";
            if (this.paramMap != null) {
                json = JsonUtil.toJsonString(this.paramMap);
            }
            if (this.data != null) {
                json = JsonUtil.toJsonString(this.data);
            }
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        } else {
            FormBody.Builder formBody = new FormBody.Builder();
            if (this.paramMap != null) {
                for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
                    formBody.add(entry.getKey(), entry.getValue().toString());
                }
            }
            requestBody = formBody.build();
        }
        this.request = new Request.Builder().post((RequestBody)requestBody).url(this.url);
        return this;
    }

    public String sync() {
        this.setHeader(this.request);
        try {
            Response response = okHttpClient.newCall(this.request.build()).execute();
            assert (response.body() != null);
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage();
        }
    }

    public String async() {
        final StringBuilder buffer = new StringBuilder("");
        this.setHeader(this.request);
        okHttpClient.newCall(this.request.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                buffer.append("\u8bf7\u6c42\u51fa\u9519\uff1a").append(e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                assert (response.body() != null);
                buffer.append(response.body().string());
                OkHttpUtil.getSemaphoreInstance().release();
            }
        });
        try {
            OkHttpUtil.getSemaphoreInstance().acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public void async(final ICallBack callBack) {
        this.setHeader(this.request);
        okHttpClient.newCall(this.request.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callBack.onFailure(call, e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                assert (response.body() != null);
                callBack.onSuccessful(call, response.body().string());
            }
        });
    }

    private void setHeader(Request.Builder request) {
        if (this.headerMap != null) {
            try {
                for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static SSLSocketFactory createSSLSocketFactory(TrustManager[] trustAllCerts) {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssfFactory;
    }

    private static TrustManager[] buildTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }

    public static interface ICallBack {
        public void onSuccessful(Call var1, String var2);

        public void onFailure(Call var1, String var2);
    }
}

