/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class JKMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final Object[] NULL_ELEMENT_ARRAY = new Object[]{null, ""};
    public static final List<Object> NULL_ELEMENT_LIST = Arrays.asList(NULL_ELEMENT_ARRAY);
    static Pattern patternNumber = Pattern.compile("[0-9]*");

    @Override
    public Object get(Object key) {
        if ("this".equals(key)) {
            return this;
        }
        return super.get(key);
    }

    public Object get(Object key, Object defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public int getInt(String key) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return 0;
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public long getLong(String key) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return 0L;
        }
        return Long.valueOf(String.valueOf(value));
    }

    public double getDouble(String key) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return 0.0;
        }
        return Double.valueOf(String.valueOf(value));
    }

    public boolean getBoolean(String key) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return false;
        }
        return Boolean.valueOf(String.valueOf(value));
    }

    public Date getDateByFormat(String key, String format) {
        try {
            return new SimpleDateFormat(format).parse(this.getString(key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Date getDate(String key) {
        return this.getDateByFormat(key, "yyyy-MM-dd");
    }

    public Date getDateTime(String key) {
        return this.getDateByFormat(key, "yyyy-MM-dd HH:mm:ss");
    }

    public JKMap getMap(String key) {
        Object value = this.get(key);
        if (value == null) {
            return JKMap.getWaMap();
        }
        if (value instanceof Map) {
            return JKMap.getWaMap((Map)value);
        }
        if (value instanceof String) {
            return JKMap.getWaMap().setJsonString((String)value);
        }
        throw new RuntimeException("\u503c\u65e0\u6cd5\u8f6c\u5316\u4e3aWaMap: " + value);
    }

    public List<Object> getList(String key) {
        Object value = this.get(key);
        List<Object> list = null;
        if (value == null || value.equals("")) {
            list = new ArrayList<Object>();
        } else if (value instanceof List) {
            list = (List)value;
        } else {
            list = new ArrayList();
            list.add(value);
        }
        return list;
    }

    public <T> List<T> getList(String key, Class<T> cs) {
        List<Object> list = this.getList(key);
        ArrayList<T> list2 = new ArrayList<T>();
        for (Object obj : list) {
            T objC = JKMap.getValueByClass(obj, cs);
            list2.add(objC);
        }
        return list2;
    }

    public <T> List<T> getListByComma(String key, Class<T> cs) {
        String listStr = this.getString(key);
        if (listStr == null || listStr.equals("")) {
            return new ArrayList();
        }
        String[] arr = listStr.split(",");
        ArrayList<T> list = new ArrayList<T>();
        for (String str : arr) {
            if (cs == Integer.TYPE || cs == Integer.class || cs == Long.TYPE || cs == Long.class) {
                str = str.trim();
            }
            T objC = JKMap.getValueByClass(str, cs);
            list.add(objC);
        }
        return list;
    }

    public <T> T getModel(Class<T> cs) {
        try {
            return this.getModelByObject(cs.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getModelByObject(T obj) {
        Class<?> cs = obj.getClass();
        for (Field field : cs.getDeclaredFields()) {
            try {
                Object value = this.get(field.getName());
                if (value == null) continue;
                field.setAccessible(true);
                Object valueConvert = JKMap.getValueByClass(value, field.getType());
                field.set(obj, valueConvert);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("\u5c5e\u6027\u53d6\u503c\u51fa\u9519\uff1a" + field.getName(), e);
            }
        }
        return obj;
    }

    public static <T> T getValueByClass(Object obj, Class<T> cs) {
        String obj2 = String.valueOf(obj);
        Object obj3 = null;
        obj3 = cs.equals(String.class) ? obj2 : (cs.equals(Integer.TYPE) || cs.equals(Integer.class) ? Integer.valueOf(obj2) : (cs.equals(Long.TYPE) || cs.equals(Long.class) ? Long.valueOf(obj2) : (cs.equals(Short.TYPE) || cs.equals(Short.class) ? Short.valueOf(obj2) : (cs.equals(Byte.TYPE) || cs.equals(Byte.class) ? Byte.valueOf(obj2) : (cs.equals(Float.TYPE) || cs.equals(Float.class) ? Float.valueOf(obj2) : (cs.equals(Double.TYPE) || cs.equals(Double.class) ? Double.valueOf(obj2) : (cs.equals(Boolean.TYPE) || cs.equals(Boolean.class) ? Boolean.valueOf(obj2) : obj)))))));
        return (T)obj3;
    }

    public void setDefaultValue(String key, Object defaultValue) {
        if (this.isNull(key)) {
            this.set(key, defaultValue);
        }
    }

    public JKMap set(String key, Object value) {
        if (key.toLowerCase().equals("this")) {
            return this;
        }
        this.put(key, value);
        return this;
    }

    public JKMap setMap(Map<String, ?> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.set(key, map.get(key));
            }
        }
        return this;
    }

    public JKMap setModel(Object model) {
        Field[] fields;
        if (model == null) {
            return this;
        }
        for (Field field : fields = model.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                if (isStatic) continue;
                this.set(field.getName(), field.get(model));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public JKMap setJsonString(String jsonString) {
        try {
            Map map = (Map)new ObjectMapper().readValue(jsonString, Map.class);
            return this.setMap(map);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JKMap delete(String key) {
        this.remove(key);
        return this;
    }

    public JKMap clearNull() {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!this.isNull(key)) continue;
            iterator.remove();
            this.remove(key);
        }
        return this;
    }

    public JKMap clearIn(String ... keys) {
        List<String> keys2 = Arrays.asList(keys);
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!keys2.contains(key)) continue;
            iterator.remove();
            this.remove(key);
        }
        return this;
    }

    public JKMap clearNotIn(String ... keys) {
        List<String> keys2 = Arrays.asList(keys);
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (keys2.contains(key)) continue;
            iterator.remove();
            this.remove(key);
        }
        return this;
    }

    public JKMap clearAll() {
        this.clear();
        return this;
    }

    public static JKMap getWaMap() {
        return new JKMap();
    }

    public static JKMap getWaMap(String key, Object value) {
        return new JKMap().set(key, value);
    }

    public static JKMap getWaMap(Map<String, ?> map) {
        return new JKMap().setMap(map);
    }

    public static JKMap getWaMapByModel(Object model) {
        return JKMap.getWaMap().setModel(model);
    }

    public static List<JKMap> getWaMapByList(List<?> list) {
        ArrayList<JKMap> listMap = new ArrayList<JKMap>();
        for (Object model : list) {
            listMap.add(JKMap.getWaMapByModel(model));
        }
        return listMap;
    }

    public JKMap cloneKeys(String ... keys) {
        JKMap so = new JKMap();
        for (String key : keys) {
            so.set(key, this.get(key));
        }
        return so;
    }

    public JKMap cloneWaMap() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(key, this.get(key));
        }
        return so;
    }

    public JKMap toUpperCase() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(key.toUpperCase(), this.get(key));
        }
        this.clearAll().setMap(so);
        return this;
    }

    public JKMap toLowerCase() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(key.toLowerCase(), this.get(key));
        }
        this.clearAll().setMap(so);
        return this;
    }

    public JKMap toKebabCase() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(JKMap.wordEachKebabCase(key), this.get(key));
        }
        this.clearAll().setMap(so);
        return this;
    }

    public JKMap toHumpCase() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(JKMap.wordEachBigFs(key), this.get(key));
        }
        this.clearAll().setMap(so);
        return this;
    }

    public JKMap humpToLineCase() {
        JKMap so = new JKMap();
        for (String key : this.keySet()) {
            so.set(JKMap.wordHumpToLine(key), this.get(key));
        }
        this.clearAll().setMap(so);
        return this;
    }

    public boolean isNull(String key) {
        return this.valueIsNull(this.get(key));
    }

    public boolean isContainNull(String ... keys) {
        for (String key : keys) {
            if (!this.isNull(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotNull(String key) {
        return !this.isNull(key);
    }

    public boolean has(String key) {
        return !this.isNull(key);
    }

    public boolean valueIsNull(Object value) {
        return NULL_ELEMENT_LIST.contains(value);
    }

    public JKMap checkNull(String ... keys) {
        for (String key : keys) {
            if (!this.isNull(key)) continue;
            throw new RuntimeException("\u53c2\u6570" + key + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this;
    }

    public boolean isNumber(String key) {
        String value = this.getString(key);
        if (value == null) {
            return false;
        }
        return patternNumber.matcher(value).matches();
    }

    public String toJsonString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JKMap getRequestWaMap() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            throw new RuntimeException("\u5f53\u524d\u7ebf\u7a0b\u975eJavaWeb\u73af\u5883");
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (request.getAttribute("currentWaMap") == null || !(request.getAttribute("currentWaMap") instanceof JKMap)) {
            JKMap.initRequestWaMap(request);
        }
        return (JKMap)request.getAttribute("currentWaMap");
    }

    private static void initRequestWaMap(HttpServletRequest request) {
        JKMap WaMap = new JKMap();
        Map parameterMap = request.getParameterMap();
        for (String key : parameterMap.keySet()) {
            try {
                String[] values = (String[])parameterMap.get(key);
                if (values.length == 1) {
                    WaMap.set(key, values[0]);
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (String v : values) {
                    list.add(v);
                }
                WaMap.set(key, list);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        request.setAttribute("currentWaMap", (Object)WaMap);
    }

    public static boolean isJavaWeb() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes != null;
    }

    public int getKeyPageNo() {
        int pageNo = this.getInt("pageNo", 1);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        return pageNo;
    }

    public int getKeyPageSize() {
        int pageSize = this.getInt("pageSize", 10);
        if (pageSize <= 0 || pageSize > 1000) {
            pageSize = 10;
        }
        return pageSize;
    }

    public int getKeySortType() {
        return this.getInt("sortType");
    }

    public static List<JKMap> listToTree(List<JKMap> list, String idKey, String parentIdKey, String childListKey) {
        ArrayList<JKMap> newTreeList = new ArrayList<JKMap>();
        JKMap hash = new JKMap();
        for (int i = 0; i < list.size(); ++i) {
            JKMap json = list.get(i);
            hash.put(json.getString(idKey), json);
        }
        for (int j = 0; j < list.size(); ++j) {
            JKMap aVal = list.get(j);
            JKMap hashVp = (JKMap)hash.get(aVal.get(parentIdKey, "").toString());
            if (hashVp != null) {
                List<JKMap> ch;
                if (hashVp.get(childListKey) != null) {
                    ch = (List)hashVp.get(childListKey);
                    ch.add(aVal);
                    hashVp.put(childListKey, ch);
                    continue;
                }
                ch = new ArrayList();
                ch.add(aVal);
                hashVp.put(childListKey, ch);
                continue;
            }
            newTreeList.add(aVal);
        }
        return newTreeList;
    }

    private static String wordEachBig(String str) {
        String newStr = "";
        for (String s : str.split("_")) {
            newStr = newStr + JKMap.wordFirstBig(s);
        }
        return newStr;
    }

    private static String wordEachBigFs(String str) {
        return JKMap.wordFirstSmall(JKMap.wordEachBig(str));
    }

    private static String wordFirstBig(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    private static String wordFirstSmall(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }

    private static String wordEachKebabCase(String str) {
        return str.replaceAll("_", "-");
    }

    private static String wordHumpToLine(String str) {
        return str.replaceAll("[A-Z]", "_$0").toLowerCase();
    }
}

