/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.assertion;

import cn.jrack.core.exception.RunTimeException;
import java.util.Collection;
import java.util.Map;

public class Asserts {
    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNullString(String str) {
        return Asserts.isNull(str) || "".equals(str);
    }

    public static boolean isAllNullString(String ... str) {
        boolean isNull = true;
        for (String item : str) {
            if (!Asserts.isNotNullString(item)) continue;
            isNull = false;
        }
        return isNull;
    }

    public static boolean isNotNullString(String str) {
        return !Asserts.isNullString(str);
    }

    public static boolean isAllNotNullString(String ... str) {
        boolean isNotNull = true;
        for (String item : str) {
            if (!Asserts.isNullString(item)) continue;
            isNotNull = false;
        }
        return isNotNull;
    }

    public static boolean isEquals(String str1, String str2) {
        if (Asserts.isNull(str1) && Asserts.isNull(str2)) {
            return true;
        }
        if (Asserts.isNull(str1) || Asserts.isNull(str2)) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (Asserts.isNull(str1) && Asserts.isNull(str2)) {
            return true;
        }
        if (Asserts.isNull(str1) || Asserts.isNull(str2)) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean isNullCollection(Collection collection) {
        return Asserts.isNull(collection) || collection.size() == 0;
    }

    public static boolean isNotNullCollection(Collection collection) {
        return !Asserts.isNullCollection(collection);
    }

    public static boolean isNullMap(Map map) {
        return Asserts.isNull(map) || map.size() == 0;
    }

    public static boolean isNotNullMap(Map map) {
        return !Asserts.isNullMap(map);
    }

    public static void checkNull(Object key, String msg) {
        if (key == null) {
            throw new RunTimeException(msg);
        }
    }

    public static void checkNotNull(Object object, String msg) {
        if (Asserts.isNull(object)) {
            throw new RunTimeException(msg);
        }
    }

    public static void checkNullString(String key, String msg) {
        if (Asserts.isNull(key) || Asserts.isEquals("", key)) {
            throw new RunTimeException(msg);
        }
    }

    public static void checkNullCollection(Collection collection, String msg) {
        if (Asserts.isNullCollection(collection)) {
            throw new RunTimeException(msg);
        }
    }

    public static void checkNullMap(Map map, String msg) {
        if (Asserts.isNullMap(map)) {
            throw new RunTimeException(msg);
        }
    }
}

