package cn.jrack.core.util.common;

import cn.jrack.core.constant.SystemConstant;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;

/**
 * 描述:文 件 工 具 类
 * Class:FileUtil
 * Author:ZY
 * Date: 2021/3/31 4:00 下午
 **/
public class FileUtil {

    public File convertMultipartFileToFile(MultipartFile file) throws IOException {
        File convFile = null;
        if (file.equals("") || file.getSize() <= 0) {
            System.out.println("File is empty or its size is zero, please check!");
        } else {
            InputStream inputStream = file.getInputStream();
            convFile = new File(file.getOriginalFilename());
            FileOutputStream fos = new FileOutputStream(convFile);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.close();
            inputStream.close();
        }
        return convFile;
    }

    public static String getPrintSize(long size) {
        // 如果字节数少于1024，则直接以B为单位，否则先除于1024，后3位因太少无意义
        if (size < 1024) {
            return String.valueOf(size) + "B";
        } else {
            size = size / 1024;
        }
        // 如果原字节数除于1024之后，少于1024，则可以直接以KB作为单位
        // 因为还没有到达要使用另一个单位的时候
        // 接下去以此类推
        if (size < 1024) {
            return String.valueOf(size) + "KB";
        } else {
            size = size / 1024;
        }
        if (size < 1024) {
            // 因为如果以MB为单位的话，要保留最后1位小数，
            // 因此，把此数乘以100之后再取余
            size = size * 100;
            return String.valueOf((size / 100)) + "." + String.valueOf((size % 100)) + "MB";
        } else {
            // 否则如果要以GB为单位的，先除于1024再作同样的处理
            size = size * 100 / 1024;
            return String.valueOf((size / 100)) + "." + String.valueOf((size % 100)) + "GB";
        }
    }

    /**
     * @describe:验证文件是否存在
     * @author: 囧 四
     * @date: 2021-08-08
     */
    public static Boolean exists(String filePath) {
        return exists(filePath, false);
    }

    public static Boolean exists(String filePath, Boolean createPath) {
        File file = new File(filePath);
        if (!file.exists()) {
            if (createPath) {
                file.mkdirs();
            }
            return false;
        }
        return true;
    }

    /**
     * @describe :删除附件
     * @author : 囧 四
     */
    public static Boolean delete(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }


    /**
     * @param file     文件
     * @param path     文件存放路径
     * @return
     */
    public static boolean upload(MultipartFile file, String path) {

        //确定上传的文件名
        System.out.println("上传文件：" + path);

        File dest = new File(path);

        //判断文件父目录是否存在
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }

        try {
            //保存文件
            file.transferTo(dest);
            return true;
        } catch (IllegalStateException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return false;
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return false;
        }

    }

    public static void downLoad(HttpServletResponse response, FileInputStream fileInputStream, String fileName) throws UnsupportedEncodingException {
        //1.设置文件ContentType类型，这样设置，会自动判断下载文件类型
        response.setContentType("multipart/form-data");
        //2.设置文件头：最后一个参数是设置下载文件名(假如我们叫a.pdf)
        response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, SystemConstant.UTF8));
        ServletOutputStream out;
        //通过文件路径获得File对象(假如此路径中有一个download.pdf文件)
        try {
            FileInputStream inputStream = fileInputStream;
            //3.通过response获取ServletOutputStream对象(out)
            out = response.getOutputStream();
            int b = 0;
            byte[] buffer = new byte[512];
            while (b != -1) {
                b = inputStream.read(buffer);
                //4.写到输出流(out)中
                out.write(buffer, 0, b);
            }
            inputStream.close();
            out.close();
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downLoad(HttpServletResponse response, String filePath, String fileName) throws UnsupportedEncodingException {
        if (FileUtil.exists(filePath)) {
            File file = new File(filePath);
            //1.设置文件ContentType类型，这样设置，会自动判断下载文件类型
            response.setContentType("multipart/form-data");
            //2.设置文件头：最后一个参数是设置下载文件名(假如我们叫a.pdf)
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, SystemConstant.UTF8));
            ServletOutputStream out;
            //通过文件路径获得File对象(假如此路径中有一个download.pdf文件)
            try {
                FileInputStream inputStream = new FileInputStream(file);
                //3.通过response获取ServletOutputStream对象(out)
                out = response.getOutputStream();
                int b = 0;
                byte[] buffer = new byte[512];
                while (b != -1) {
                    b = inputStream.read(buffer);
                    //4.写到输出流(out)中
                    out.write(buffer, 0, b);
                }
                inputStream.close();
                out.close();
                out.flush();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


}
