package cn.jrack.core.util;


import cn.jrack.core.pojo.PageResult;
import org.dozer.DozerBeanMapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * 实现各层DTO-PO之间的复制
 */
public class BeanMapperUtil {

    @SuppressWarnings("deprecation")
    private static DozerBeanMapper dozer = new DozerBeanMapper();

    public static <T> T map(Object sourceObject, Class<T> destObjectclazz) {
        return sourceObject == null ? null : dozer.map(sourceObject, destObjectclazz);
    }

    public static <T, S> List<T> mapList(Collection<S> sourceList, Class<T> destObjectclazz) {
        if (sourceList == null) {
            return null;
        }
        List<T> destinationList = new ArrayList<T>();
        for (Iterator<S> it = sourceList.iterator(); it.hasNext(); ) {
            destinationList.add(map(it.next(), destObjectclazz));
        }
        return destinationList;
    }

    public static <T, S> PageResult<T> mapList(PageResult<S> sourceList, Class<T> destObjectclazz) {
        if (sourceList == null || sourceList.getList() == null) {
            return null;
        }
        List<T> dataList = new ArrayList<>();
        PageResult<T> destinationList = new PageResult<>();

        for (Iterator<? extends S> it = sourceList.getList().iterator(); it.hasNext(); ) {
            destinationList.getList().add(map(it.next(), destObjectclazz));
        }
        destinationList.setTotal(sourceList.getTotal());
        //destinationList.setPageSize(sourceList.getPageSize());
        return destinationList;
    }
}
