package cn.jrack.core.util.common;

import com.google.common.collect.Maps;

import java.util.*;

public class MapRemoveNullUtil {
    /**
     * 移除map中空key或者value空值
     *
     * @param map
     */

    public static void removeNullEntry(Map map) {
        removeNullKey(map);

        removeNullValue(map);

    }

    /**
     * 移除map的空key
     *
     * @param map
     * @return
     */

    public static void removeNullKey(Map map) {
        Set set = map.keySet();

        for (Iterator iterator = set.iterator(); iterator.hasNext(); ) {
            Object obj = (Object) iterator.next();

            remove(obj, iterator);

        }

    }

    /**
     * 移除map中的value空值
     *
     * @param map
     * @return
     */

    public static void removeNullValue(Map map) {
        Set set = map.keySet();

        for (Iterator iterator = set.iterator(); iterator.hasNext(); ) {
            Object obj = (Object) iterator.next();

            Object value = (Object) map.get(obj);

            remove(value, iterator);

        }
    }

    private static void remove(Object obj, Iterator iterator) {
        if (obj instanceof String) {
            String str = (String) obj;

            if (isEmpty(str)) { //过滤掉为null和""的值 主函数输出结果map：{2=BB, 1=AA, 5=CC, 8= }

// if("".equals(str.trim())){ //过滤掉为null、""和" "的值 主函数输出结果map：{2=BB, 1=AA, 5=CC}

                iterator.remove();

            }

        } else if (obj instanceof Collection) {
            Collection col = (Collection) obj;

            if (col == null || col.isEmpty()) {
                iterator.remove();

            }

        } else if (obj instanceof Map) {
            Map temp = (Map) obj;

            if (temp == null || temp.isEmpty()) {
                iterator.remove();

            }

        } else if (obj instanceof Object[]) {
            Object[] array = (Object[]) obj;

            if (array == null || array.length <= 0) {
                iterator.remove();

            }

        } else {
            if (obj == null) {
                iterator.remove();

            }

        }

    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().length() == 0;

    }
    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean isDesc) {
        Map<K, V> result = Maps.newLinkedHashMap();
        if (isDesc) {
            map.entrySet().stream().sorted(Map.Entry.<K, V>comparingByKey().reversed())
                    .forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        } else {
            map.entrySet().stream().sorted(Map.Entry.<K, V>comparingByKey())
                    .forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        }
        return result;
    }


    public static void main(String[] args) {
        Map map = new HashMap();

        map.put(1, "AA");

        map.put("2", "BB");

        map.put("5", "CC");

        map.put("6", null);

        map.put("7", "");

        map.put("8", " ");

        System.out.println(map);//输出结果：{2=BB, 1=AA, 7=, 6=null, 5=CC, 8= }

        removeNullEntry(map);

        System.out.println(map);

    }
}



