package cn.jrack.core.pojo;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * PageQuery
 *
 * @author joy
 * @date 2024-05-16
 */
public class PageQuery {
    private static final Integer PAGE_NO = 1;
    private static final Integer PAGE_SIZE = 10;

    private static final String ORDER_FORMAT = "asc";

    @ApiModelProperty(value = "页码，从 1 开始", required = true, example = "1")
    @NotNull(message = "页码不能为空")
    @Min(value = 1, message = "页码最小值为 1")
    private Integer pageNo = PAGE_NO;

    @ApiModelProperty(value = "每页条数，最大值为 100", required = true, example = "10")
    @NotNull(message = "每页条数不能为空")
    @Min(value = 1, message = "每页条数最小值为 1")
    @Max(value = 100, message = "每页条数最大值为 100")
    private Integer pageSize = PAGE_SIZE;

    private String orderColumn;

    private String orderFormat = ORDER_FORMAT;
}
