/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateUtil {
    public static final String TIME_ZONE_DEFAULT = "GMT+8";
    public static final long SECOND_MILLIS = 1000L;
    public static final String FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND = "yyyy-MM-dd HH:mm:ss";

    public static Date addTime(Duration duration) {
        return new Date(System.currentTimeMillis() + duration.toMillis());
    }

    public static boolean isExpired(Date time) {
        return System.currentTimeMillis() > time.getTime();
    }

    public static long diff(Date endTime, Date startTime) {
        return endTime.getTime() - startTime.getTime();
    }

    public static Date buildTime(int year, int mouth, int day) {
        return DateUtil.buildTime(year, mouth, day, 0, 0, 0);
    }

    public static Date buildTime(int year, int mouth, int day, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, mouth - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date max(Date a, Date b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? a : b;
    }

    public static boolean beforeNow(Date date) {
        return date.getTime() < System.currentTimeMillis();
    }

    public static boolean afterNow(Date date) {
        return date.getTime() >= System.currentTimeMillis();
    }

    public static Date addDate(int field, int amount) {
        return DateUtil.addDate(null, field, amount);
    }

    public static Date addDate(Date date, int field, int amount) {
        if (amount == 0) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTime(date);
        }
        c.add(field, amount);
        return c.getTime();
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        return date.toInstant().atZone(zoneId).toLocalDateTime();
    }

    public static LocalDate dateToLocalDate(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        return date.toInstant().atZone(zoneId).toLocalDate();
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateToDate(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        return Date.from(localDate.atStartOfDay().atZone(zoneId).toInstant());
    }

    public static LocalDateTime localDateToLocalDateTime(LocalDate localDate) {
        return localDate.atStartOfDay();
    }

    public static LocalDate localDateTimeToLocalDate(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate();
    }

    public static long durationMonths(LocalDate dateBefore, LocalDate dateAfter) {
        System.out.println(dateBefore + "  " + dateAfter);
        if (dateBefore.getDayOfMonth() > 28) {
            dateBefore = dateBefore.minusDays(5L);
        } else if (dateAfter.getDayOfMonth() > 28) {
            dateAfter = dateAfter.minusDays(5L);
        }
        return ChronoUnit.MONTHS.between(dateBefore, dateAfter);
    }

    public static long durationQuarters(LocalDate dateBefore, LocalDate dateAfter) {
        Month dateBeforeQuarter = dateBefore.getMonth().firstMonthOfQuarter();
        LocalDate dateBeforeFirstDay = LocalDate.of(dateBefore.getYear(), dateBeforeQuarter, 1);
        Month dateAfterQuarter = dateAfter.getMonth().firstMonthOfQuarter();
        LocalDate dateAfterFirstDay = LocalDate.of(dateAfter.getYear(), dateAfterQuarter, 1);
        long result = 0L;
        while (dateBeforeFirstDay.isBefore(dateAfterFirstDay)) {
            dateBeforeFirstDay = dateBeforeFirstDay.plusMonths(3L);
            ++result;
        }
        return result;
    }

    public static long durationYears(LocalDate dateBefore, LocalDate dateAfter) {
        LocalDate dateBeforeFirstDay = dateBefore.with(TemporalAdjusters.firstDayOfYear());
        LocalDate dateAfterFirstDay = dateAfter.with(TemporalAdjusters.firstDayOfYear());
        long result = 0L;
        while (dateBeforeFirstDay.isBefore(dateAfterFirstDay)) {
            dateBeforeFirstDay = dateBeforeFirstDay.plusYears(1L);
            ++result;
        }
        return result;
    }

    public static boolean beforeAddAmountEqAfter(LocalDate dateBefore, LocalDate dateAfter, long amountToAdd, TemporalUnit unit) {
        LocalDate temp = dateBefore;
        while (!temp.isEqual(dateAfter)) {
            if (temp.isAfter(dateAfter)) {
                return false;
            }
            temp = temp.plus(amountToAdd, unit);
        }
        return true;
    }

    public static LocalDate getStartOrEndDayOfQuarter(LocalDate today, Boolean isFirst) {
        LocalDate resDate = LocalDate.now();
        if (today == null) {
            today = resDate;
        }
        Month month = today.getMonth();
        Month firstMonthOfQuarter = month.firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        resDate = isFirst != false ? LocalDate.of(today.getYear(), firstMonthOfQuarter, 1) : LocalDate.of(today.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(today.isLeapYear()));
        return resDate;
    }

    public static int getSpecificYearAndMonthHasDays(int year, int month) {
        LocalDate date = LocalDate.of(year, month, 1);
        return date.lengthOfMonth();
    }

    public static int getDays(String st, String et) {
        return DateUtil.getDays(LocalDate.parse(st), LocalDate.parse(et));
    }

    public static int getDays(LocalDate st, LocalDate et) {
        int i = 1;
        while (st == et) {
            st = st.plusDays(1L);
            ++i;
        }
        return i;
    }

    public static int getSpecificYearHasDays(int year) {
        LocalDate date = LocalDate.of(year, 1, 1);
        return date.lengthOfYear();
    }

    public static List<Map<String, String>> queryWeek(String year, String month) throws ParseException {
        String[] weeks = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(sdf.parse(year + "-" + month + "-01"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int i = calendar.get(7);
        int months = calendar.get(2);
        switch (i) {
            case 1: {
                calendar.add(5, 1);
                break;
            }
            case 2: {
                calendar.add(5, 0);
                break;
            }
            case 3: {
                calendar.add(5, 6);
                break;
            }
            case 4: {
                calendar.add(5, 5);
                break;
            }
            case 5: {
                calendar.add(5, 4);
                break;
            }
            case 6: {
                calendar.add(5, 3);
                break;
            }
            case 7: {
                calendar.add(5, 2);
                break;
            }
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        int index = 0;
        while (true) {
            if (index++ > 0) {
                calendar.add(5, 1);
            }
            if (months != calendar.get(2)) break;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("start", sdf.format(calendar.getTime()));
            calendar.add(5, 6);
            map.put("end", sdf.format(calendar.getTime()));
            map.put("week", weeks[index - 1]);
            list.add(map);
        }
        return list;
    }

    public static void main(String[] args) {
        int specificYearAndMonthHasDays = DateUtil.getSpecificYearAndMonthHasDays(2024, 1);
        System.out.println("jrack_month: " + specificYearAndMonthHasDays);
        LocalDate d1 = LocalDate.of(2022, 8, 2);
        LocalDate d2 = LocalDate.of(2023, 9, 2);
        long year0 = DateUtil.durationYears(d1, d2);
        long year1 = ChronoUnit.YEARS.between(d1, d2);
        System.out.println("year0: " + year0);
        System.out.println("year1: " + year1);
        LocalDate dateBefore = LocalDate.of(2022, 1, 1);
        LocalDate dateAfter = LocalDate.of(2022, 2, 28);
        long month0 = DateUtil.durationMonths(dateBefore, dateAfter);
        long month1 = ChronoUnit.MONTHS.between(dateBefore, dateAfter);
        System.out.println("month0: " + month0);
        System.out.println("month1: " + month1);
        LocalDate[][] aa = new LocalDate[5][2];
        aa[0][0] = LocalDate.of(2022, 12, 19);
        aa[0][1] = LocalDate.of(2022, 12, 31);
        aa[1][0] = LocalDate.of(2023, 1, 1);
        aa[1][1] = LocalDate.of(2023, 3, 31);
        aa[2][0] = LocalDate.of(2023, 4, 1);
        aa[2][1] = LocalDate.of(2023, 6, 30);
        aa[3][0] = LocalDate.of(2023, 7, 1);
        aa[3][1] = LocalDate.of(2023, 9, 30);
        aa[4][0] = LocalDate.of(2023, 10, 1);
        aa[4][1] = LocalDate.of(2023, 12, 18);
        long totalDay = ChronoUnit.DAYS.between(aa[0][0], aa[4][1]);
        System.out.println("totalDay:" + totalDay);
        long totalDay1 = 0L;
        for (int i = 0; i < aa.length; ++i) {
            long days = ChronoUnit.DAYS.between(aa[i][0], aa[i][1]);
            System.out.println(aa[i][0] + " -- " + aa[i][1] + " -- " + days);
            totalDay1 += days;
        }
        System.out.println("totalDay1:" + totalDay);
    }
}

