/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util.common;

import cn.jrack.core.constant.SystemConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public File convertMultipartFileToFile(MultipartFile file) throws IOException {
        File convFile = null;
        if (file.equals((Object)"") || file.getSize() <= 0L) {
            System.out.println("File is empty or its size is zero, please check!");
        } else {
            InputStream inputStream = file.getInputStream();
            convFile = new File(file.getOriginalFilename());
            FileOutputStream fos = new FileOutputStream(convFile);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.close();
            inputStream.close();
        }
        return convFile;
    }

    public static String getPrintSize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + "B";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + "KB";
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf((size *= 100L) / 100L) + "." + String.valueOf(size % 100L) + "MB";
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + String.valueOf(size % 100L) + "GB";
    }

    public static Boolean exists(String filePath) {
        return FileUtil.exists(filePath, false);
    }

    public static Boolean exists(String filePath, Boolean createPath) {
        File file = new File(filePath);
        if (!file.exists()) {
            if (createPath.booleanValue()) {
                file.mkdirs();
            }
            return false;
        }
        return true;
    }

    public static Boolean delete(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean upload(MultipartFile file, String path) {
        System.out.println("\u4e0a\u4f20\u6587\u4ef6\uff1a" + path);
        File dest = new File(path);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            file.transferTo(dest);
            return true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void downLoad(HttpServletResponse response, FileInputStream fileInputStream, String fileName) throws UnsupportedEncodingException {
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, SystemConstant.UTF8));
        try {
            FileInputStream inputStream = fileInputStream;
            ServletOutputStream out = response.getOutputStream();
            int b = 0;
            byte[] buffer = new byte[512];
            while (b != -1) {
                b = inputStream.read(buffer);
                out.write(buffer, 0, b);
            }
            inputStream.close();
            out.close();
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downLoad(HttpServletResponse response, String filePath, String fileName) throws UnsupportedEncodingException {
        if (FileUtil.exists(filePath).booleanValue()) {
            File file = new File(filePath);
            response.setContentType("multipart/form-data");
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, SystemConstant.UTF8));
            try {
                FileInputStream inputStream = new FileInputStream(file);
                ServletOutputStream out = response.getOutputStream();
                int b = 0;
                byte[] buffer = new byte[512];
                while (b != -1) {
                    b = inputStream.read(buffer);
                    out.write(buffer, 0, b);
                }
                inputStream.close();
                out.close();
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

