/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class WaterMarkUtil {
    private static float alpha = 0.6f;
    public static final int FONT_SIZE = 20;
    private static Font font = new Font("\u5b8b\u4f53", 0, 20);
    private static Color color = Color.gray;
    private static final int XMOVE = 100;
    private static final int YMOVE = 100;

    public static void imageByText(String logoText, String srcImgPath, String targerPath) {
        WaterMarkUtil.imageByText(logoText, srcImgPath, targerPath, null);
    }

    private static int getTextLength(String text) {
        int length = text.length();
        for (int i = 0; i < text.length(); ++i) {
            String s = String.valueOf(text.charAt(i));
            if (s.getBytes().length <= 1) continue;
            ++length;
        }
        length = length % 2 == 0 ? length / 2 : length / 2 + 1;
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imageByText(String logoText, String srcImgPath, String targerPath, Integer degree) {
        InputStream is = null;
        OutputStream os = null;
        try {
            BufferedImage srcImg = ImageIO.read(new File(srcImgPath));
            int width = ((Image)srcImg).getWidth(null);
            int height = ((Image)srcImg).getHeight(null);
            BufferedImage buffImg = new BufferedImage(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 1);
            Graphics2D g = buffImg.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(srcImg.getScaledInstance(((Image)srcImg).getWidth(null), ((Image)srcImg).getHeight(null), 4), 0, 0, null);
            if (null != degree) {
                g.rotate(Math.toRadians(degree.intValue()), (double)buffImg.getWidth() / 2.0, (double)buffImg.getHeight() / 2.0);
            }
            g.setColor(color);
            g.setFont(font);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            int x = -width / 2;
            int y = -height / 2;
            int markWidth = 20 * WaterMarkUtil.getTextLength(logoText);
            int markHeight = 20;
            while ((double)x < (double)width * 1.5) {
                y = -height / 2;
                while ((double)y < (double)height * 1.5) {
                    g.drawString(logoText, x, y);
                    y += markHeight + 100;
                }
                x += markWidth + 100;
            }
            g.dispose();
            os = new FileOutputStream(targerPath);
            ImageIO.write((RenderedImage)buffImg, "JPG", os);
            System.out.println("\u6dfb\u52a0\u6c34\u5370\u6587\u5b57\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String srcImgPath = "/Users/zhaoyang/cbd/\u8d75\u79d8/1-h-f.jpg";
        String text = "\u4ec5\u7528\u4e8e\u4f18\u9c9c\u96c6APP\u5f00\u901a\u95e8\u7981\u4f7f\u7528";
        WaterMarkUtil.imageByText(text, srcImgPath, "/Users/zhaoyang/cbd/\u8d75\u79d8/1-hf-s.jpg");
        WaterMarkUtil.imageByText(text, srcImgPath, "/Users/zhaoyang/cbd/\u8d75\u79d8/1-hf-s.jpg", -45);
        System.out.println("\u7ed9\u56fe\u7247\u6dfb\u52a0\u6c34\u5370\u6587\u5b57\u5b8c\u6bd5");
    }
}

