/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util;

import cn.jrack.core.pojo.ModifiedPropertyInfo;
import cn.jrack.core.pojo.PropertyModelInfo;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class CompareObjectPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareObjectPropertyUtil.class);

    public static <T> List<ModifiedPropertyInfo> getDifferentProperty(T oldObj, T newObj, String ... ignoreProperties) {
        if (oldObj != null && newObj != null) {
            if ((ignoreProperties == null || ignoreProperties.length > 0) && oldObj.equals(newObj)) {
                return Collections.emptyList();
            }
            List<PropertyModelInfo> oldObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(oldObj, ignoreProperties);
            if (!CollectionUtils.isEmpty(oldObjectPropertyValue)) {
                String propertyName;
                ArrayList<ModifiedPropertyInfo> modifiedPropertyInfos = new ArrayList<ModifiedPropertyInfo>(oldObjectPropertyValue.size());
                List<PropertyModelInfo> newObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(newObj, ignoreProperties);
                HashMap<String, Object> objectMap = new HashMap<String, Object>(newObjectPropertyValue.size());
                for (PropertyModelInfo propertyModelInfo : newObjectPropertyValue) {
                    propertyName = propertyModelInfo.getPropertyName();
                    Object value = propertyModelInfo.getValue();
                    objectMap.put(propertyName, value);
                }
                for (PropertyModelInfo propertyModelInfo : oldObjectPropertyValue) {
                    propertyName = propertyModelInfo.getPropertyName();
                    String propertyComment = propertyModelInfo.getPropertyComment();
                    Object value = propertyModelInfo.getValue();
                    if (!objectMap.containsKey(propertyName)) continue;
                    Object newValue = objectMap.get(propertyName);
                    ModifiedPropertyInfo modifiedPropertyInfo = new ModifiedPropertyInfo();
                    if (value != null && newValue != null) {
                        if (value.equals(newValue)) continue;
                        modifiedPropertyInfo.setPropertyName(propertyName);
                        modifiedPropertyInfo.setPropertyComment(propertyComment);
                        modifiedPropertyInfo.setOldValue(value);
                        modifiedPropertyInfo.setNewValue(newValue);
                        modifiedPropertyInfos.add(modifiedPropertyInfo);
                        continue;
                    }
                    if ((newValue != null || value == null || StringUtils.isBlank((CharSequence)value.toString())) && (value != null || newValue == null || StringUtils.isBlank((CharSequence)newValue.toString()))) continue;
                    modifiedPropertyInfo.setPropertyName(propertyName);
                    modifiedPropertyInfo.setPropertyComment(propertyComment);
                    modifiedPropertyInfo.setOldValue(value);
                    modifiedPropertyInfo.setNewValue(newValue);
                    modifiedPropertyInfos.add(modifiedPropertyInfo);
                }
                return modifiedPropertyInfos;
            }
        }
        return Collections.emptyList();
    }

    public static <T> List<PropertyModelInfo> getObjectPropertyValue(T obj, String ... ignoreProperties) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(objClass);
            ArrayList<PropertyModelInfo> modelInfos = new ArrayList<PropertyModelInfo>(propertyDescriptors.length);
            Field[] fields = objClass.getDeclaredFields();
            ArrayList ignoreList = Lists.newArrayList();
            ignoreList.add("serialVersionUID");
            if (ignoreProperties != null) {
                ignoreList.addAll(Arrays.asList(ignoreProperties));
            }
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                if (ignoreList.contains(fieldName)) continue;
                PropertyModelInfo propertyModelInfo = new PropertyModelInfo();
                propertyModelInfo.setPropertyName(fieldName);
                propertyModelInfo.setReturnType(field.getType());
                Object fieldValue = CompareObjectPropertyUtil.getFieldValueByName(fieldName, obj);
                propertyModelInfo.setValue(fieldValue == null ? "" : fieldValue);
                modelInfos.add(propertyModelInfo);
            }
            return modelInfos;
        }
        return Collections.emptyList();
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }
}

