/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.exception.util;

import cn.jrack.core.exception.ErrorCode;
import cn.jrack.core.exception.ServiceException;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ServiceExceptionUtil.class);
    private static final ConcurrentMap<Integer, String> MESSAGES = new ConcurrentHashMap<Integer, String>();

    public static void putAll(Map<Integer, String> messages) {
        MESSAGES.putAll(messages);
    }

    public static void put(Integer code, String message) {
        MESSAGES.put(code, message);
    }

    public static void delete(Integer code, String message) {
        MESSAGES.remove(code, message);
    }

    public static ServiceException exception(ErrorCode errorCode) {
        String messagePattern = MESSAGES.getOrDefault(errorCode.getCode(), errorCode.getMsg());
        return ServiceExceptionUtil.exception0(errorCode.getCode(), messagePattern, new Object[0]);
    }

    public static ServiceException exception(ErrorCode errorCode, Object ... params) {
        String messagePattern = MESSAGES.getOrDefault(errorCode.getCode(), errorCode.getMsg());
        return ServiceExceptionUtil.exception0(errorCode.getCode(), messagePattern, params);
    }

    public static ServiceException exception(Integer code) {
        return ServiceExceptionUtil.exception0(code, (String)MESSAGES.get(code), new Object[0]);
    }

    public static ServiceException exception(Integer code, Object ... params) {
        return ServiceExceptionUtil.exception0(code, (String)MESSAGES.get(code), params);
    }

    public static ServiceException exception0(Integer code, String messagePattern, Object ... params) {
        String message = ServiceExceptionUtil.doFormat(code, messagePattern, params);
        return new ServiceException(code, message);
    }

    @VisibleForTesting
    public static String doFormat(int code, String messagePattern, Object ... params) {
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        int i = 0;
        for (int l = 0; l < params.length; ++l) {
            int j = messagePattern.indexOf("{}", i);
            if (j == -1) {
                log.error("[doFormat][\u53c2\u6570\u8fc7\u591a\uff1a\u9519\u8bef\u7801({})|\u9519\u8bef\u5185\u5bb9({})|\u53c2\u6570({})", new Object[]{code, messagePattern, params});
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i));
                return sbuf.toString();
            }
            sbuf.append(messagePattern, i, j);
            sbuf.append(params[l]);
            i = j + 2;
        }
        if (messagePattern.indexOf("{}", i) != -1) {
            log.error("[doFormat][\u53c2\u6570\u8fc7\u5c11\uff1a\u9519\u8bef\u7801({})|\u9519\u8bef\u5185\u5bb9({})|\u53c2\u6570({})", new Object[]{code, messagePattern, params});
        }
        sbuf.append(messagePattern.substring(i));
        return sbuf.toString();
    }
}

