/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<Object> getAllObjectByInterface(Class<?> c) throws InstantiationException, IllegalAccessException {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Class<?>> classes = ClassUtil.getAllClassByInterface(c);
        for (int i = 0; i < classes.size(); ++i) {
            list.add(classes.get(i).newInstance());
        }
        return list;
    }

    public static List<Class<?>> getAllClassByInterface(Class<?> c) {
        if (!c.isInterface()) {
            return null;
        }
        String packageName = c.getPackage().getName();
        List<Class<?>> allClass = null;
        try {
            allClass = ClassUtil.getAllClassFromPackage(packageName);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < allClass.size(); ++i) {
            if (!c.isAssignableFrom(allClass.get(i)) || c.equals(allClass.get(i))) continue;
            list.add(allClass.get(i));
        }
        return list;
    }

    private static List<Class<?>> getAllClassFromPackage(String packageName) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace(".", "/");
        Enumeration<URL> enumeration = classLoader.getResources(path);
        List<String> classNames = ClassUtil.getClassNames(enumeration, packageName);
        ArrayList classes = new ArrayList();
        for (int i = 0; i < classNames.size(); ++i) {
            classes.add(Class.forName(classNames.get(i)));
        }
        return classes;
    }

    public static List<String> getClassNames(Enumeration<URL> enumeration, String packageName) {
        List<String> classNames = null;
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            if (url == null) continue;
            String type = url.getProtocol();
            if (type.equals("file")) {
                System.out.println("type : file");
                String fileSearchPath = url.getPath();
                if (fileSearchPath.contains("META-INF")) {
                    System.out.println("continue + " + fileSearchPath);
                    continue;
                }
                classNames = ClassUtil.getClassNameByFile(fileSearchPath);
                continue;
            }
            if (type.equals("jar")) {
                try {
                    System.out.println("type : jar");
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    classNames = ClassUtil.getClassNameByJar(jarFile, packageName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("type : none");
        }
        return classNames;
    }

    public static List<String> getClassNameByFile(String fileSearchPath) {
        File[] childFiles;
        ArrayList<String> classNames = new ArrayList<String>();
        File file = new File(fileSearchPath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                classNames.addAll(ClassUtil.getClassNameByFile(childFile.getPath()));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            String className = childFilePath.substring(childFilePath.lastIndexOf("\\bin\\") + 1, childFilePath.length()).replaceAll("\\\\", ".");
            className = className.substring(4, className.indexOf(".class"));
            classNames.add(className);
        }
        return classNames;
    }

    public static List<String> getClassNameByJar(JarFile jarFile, String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<JarEntry> entrys = jarFile.entries();
        while (entrys.hasMoreElements()) {
            JarEntry jarEntry = entrys.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.replace("/", ".");
            className = className.substring(0, className.indexOf(".class"));
            classNames.add(className);
        }
        return classNames;
    }
}

