/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util.common;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MapRemoveNullUtils {
    public static void removeNullEntry(Map map) {
        MapRemoveNullUtils.removeNullKey(map);
        MapRemoveNullUtils.removeNullValue(map);
    }

    public static void removeNullKey(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            MapRemoveNullUtils.remove(obj, iterator);
        }
    }

    public static void removeNullValue(Map map) {
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            Object value = map.get(obj);
            MapRemoveNullUtils.remove(value, iterator);
        }
    }

    private static void remove(Object obj, Iterator iterator) {
        if (obj instanceof String) {
            String str = (String)obj;
            if (MapRemoveNullUtils.isEmpty(str)) {
                iterator.remove();
            }
        } else if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (col == null || col.isEmpty()) {
                iterator.remove();
            }
        } else if (obj instanceof Map) {
            Map temp = (Map)obj;
            if (temp == null || temp.isEmpty()) {
                iterator.remove();
            }
        } else if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            if (array == null || array.length <= 0) {
                iterator.remove();
            }
        } else if (obj == null) {
            iterator.remove();
        }
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || obj.toString().length() == 0;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (isDesc) {
            map.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).forEachOrdered(e -> result.put((Comparable)e.getKey(), e.getValue()));
        } else {
            map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> result.put((Comparable)e.getKey(), e.getValue()));
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(1, "AA");
        map.put("2", "BB");
        map.put("5", "CC");
        map.put("6", null);
        map.put("7", "");
        map.put("8", " ");
        System.out.println(map);
        MapRemoveNullUtils.removeNullEntry(map);
        System.out.println(map);
    }
}

