/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util.collection;

import cn.jrack.core.util.collection.CollectionUtil;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;

public class ArrayUtil {
    @SafeVarargs
    public static <T> Consumer<T>[] append(Consumer<T> object, Consumer<T> ... newElements) {
        if (object == null) {
            return newElements;
        }
        Consumer[] result = (Consumer[])cn.hutool.core.util.ArrayUtil.newArray(Consumer.class, (int)(1 + newElements.length));
        result[0] = object;
        System.arraycopy(newElements, 0, result, 1, newElements.length);
        return result;
    }

    public static <T, V> V[] toArray(Collection<T> from, Function<T, V> mapper) {
        return ArrayUtil.toArray(CollectionUtil.convertList(from, mapper));
    }

    public static <T> T[] toArray(Collection<T> from) {
        if (cn.hutool.core.collection.CollectionUtil.isEmpty(from)) {
            return new Object[0];
        }
        return cn.hutool.core.util.ArrayUtil.toArray(from, (Class)cn.hutool.core.collection.CollectionUtil.getElementType(from.iterator()));
    }
}

