/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;

public class NetWorkUtil {
    private static final int SLEEP_TIME = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getNetworkDownUp() {
        Properties props = System.getProperties();
        String os = props.getProperty("os.name").toLowerCase();
        os = os.startsWith("win") ? "windows" : "linux";
        HashMap<String, String> result = new HashMap<String, String>();
        Process pro = null;
        Runtime r = Runtime.getRuntime();
        BufferedReader input = null;
        String rxPercent = "";
        String txPercent = "";
        try {
            String command = "windows".equals(os) ? "netstat -e" : "ifconfig";
            pro = r.exec(command);
            input = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            long[] result1 = NetWorkUtil.readInLine(input, os);
            Thread.sleep(2000L);
            pro.destroy();
            input.close();
            pro = r.exec(command);
            input = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            long[] result2 = NetWorkUtil.readInLine(input, os);
            rxPercent = NetWorkUtil.formatNumber((double)(result2[0] - result1[0]) / 2048.0);
            txPercent = NetWorkUtil.formatNumber((double)(result2[1] - result1[1]) / 2048.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Optional.ofNullable(pro).ifPresent(p -> p.destroy());
        }
        result.put("rxPercent", rxPercent);
        result.put("txPercent", txPercent);
        return result;
    }

    private static long[] readInLine(BufferedReader input, String osType) {
        long[] arr = new long[2];
        StringTokenizer tokenStat = null;
        try {
            if (osType.equals("linux")) {
                long rx = 0L;
                long tx = 0L;
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (line.indexOf("RX packets") >= 0) {
                        rx += Long.parseLong(line.substring(line.indexOf("RX packets") + 11, line.indexOf(" ", line.indexOf("RX packets") + 11)));
                        continue;
                    }
                    if (line.indexOf("TX packets") < 0) continue;
                    tx += Long.parseLong(line.substring(line.indexOf("TX packets") + 11, line.indexOf(" ", line.indexOf("TX packets") + 11)));
                }
                arr[0] = rx;
                arr[1] = tx;
            } else {
                input.readLine();
                input.readLine();
                input.readLine();
                input.readLine();
                tokenStat = new StringTokenizer(input.readLine());
                tokenStat.nextToken();
                arr[0] = Long.parseLong(tokenStat.nextToken());
                arr[1] = Long.parseLong(tokenStat.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arr;
    }

    private static String formatNumber(double f) {
        return new Formatter().format("%.2f", f).toString();
    }

    public static void main(String[] args) {
        Map<String, String> result = NetWorkUtil.getNetworkDownUp();
        System.out.println(result.get("rxPercent"));
        System.out.println(result.get("txPercent"));
    }
}

