package cn.jque.core.util;

import cn.jque.core.model.ChromelessEnum;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Liu.ShiTing
 * @version 1.0.0
 * @date 2022-11-07 20:26:52
 */
@Slf4j
public class PdfConvertUtils {

	static File TMP_DIR;

	static {
		File dir = new File("growthReport");
		if (!dir.exists()) {
			dir.mkdirs();
		}
		TMP_DIR = dir;
	}


	/**
	 * 生成pdf文件格式
	 * @param html       html模板数据
	 * @param pageLayout 页面布局
	 * @return 返回保存在文件服务器上的路径
	 */
	public static File generatePdfByChrome(String html, String pageLayout) {

		if (pageLayout.isEmpty()) {
			pageLayout = ChromelessEnum.A4_2.toString();
		}

		File src = null;
		File dest = null;

		try {
			Date date = new Date();
			SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
			String nowStr = format.format(date);

			src = createTempFile("_" + nowStr + ".html");
			dest = createTempFile("_" + nowStr + ".pdf");

			byte[] bytes = html.getBytes();
			assert src != null;
			Files.write(src.toPath(), bytes);

			//PDF文件生成
			log.info("开始将html转换为pdf文件");
			Chromeless2PdfUtils.transToPdf(src, dest, pageLayout);
			log.info("转换为pdf文件结束");

			return dest;
		} catch (Exception ex) {
			throw new RuntimeException("convert html file to pdf error ", ex);
		} finally {
			//上传完成后，需要删除掉本地的临时文件
			/*if (src != null && src.exists()) {
				src.delete();
			}
			if (dest != null && dest.exists()) {
				dest.delete();
			}*/

		}
	}

	private static File createTempFile(String ext) {
		try {
			return File.createTempFile("file_", ext, TMP_DIR);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

}
