package cn.jque.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

/**
 * Json处理工具类
 * @author Liu.ShiTing
 * @version 1.0.0
 * @date 2022-12-21 16:25:27
 */
public class JsonConvertUtils {


	public static ObjectMapper objectMapper = new ObjectMapper();

	/**
	 * 将Json串转为Java对象
	 * @param supplier 对象供应方
	 * @param str      Json串
	 * @param <T>      对象类型
	 * @return Java对象
	 */
	public static <T> T convertJsonToBean(Supplier<T> supplier, String str) {

		if (null != supplier) {
			T t = supplier.get();
			try {
				return (T) objectMapper.readValue(str, t.getClass());
			} catch (JsonProcessingException e) {
				e.printStackTrace();
			}
		}

		return null;
	}

	/**
	 * 将Json数组串转为List对象
	 * @param supplier 对象供应方
	 * @param str      Json数组串
	 * @param <T>      对象类型
	 * @return List对象
	 */
	public static <T> List<T> convertJsonArrayToList(Supplier<T> supplier, String str) {

		if (null != supplier) {
			T t = supplier.get();
			try {
				CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, t.getClass());
				return objectMapper.readValue(str, listType);
			} catch (JsonProcessingException e) {
				e.printStackTrace();
			}
		}

		return null;
	}

	/**
	 * 将Json数组串转为数组
	 * @param supplier 对象供应方
	 * @param str      Json数组串
	 * @param <T>      对象类型
	 * @return []
	 */
	public static <T> T[] convertJsonArrayToArray(Supplier<T> supplier, String str) {

		if (null != supplier) {
			T t = supplier.get();
			try {
				ArrayType arrayType = objectMapper.getTypeFactory().constructArrayType(t.getClass());
				return objectMapper.readValue(str, arrayType);
			} catch (JsonProcessingException e) {
				e.printStackTrace();
			}
		}

		return null;
	}

	/**
	 * 将Java对象转为Json串
	 * @param t   实体对象
	 * @param <T> 对象类型
	 * @return String
	 */
	public static <T> String convertBeanToJson(T t) {

		if (null == t) {
			return null;
		}
		try {
			return objectMapper.writeValueAsString(t);
		} catch (JsonProcessingException e) {
			e.printStackTrace();
		}

		return null;
	}

}