package cn.jque.core.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * 集合工具类
 * @author Liu.ShiTing
 * @version 1.0.0
 * @date 2022-12-09 19:46:06
 */
public class CollectionConvertUtils {

	/**
	 * 根据条件对list集合中的数据去重
	 * list.stream().filter(distinctByKey(SchoolStageRemoteResponse::getStageId)).collect(Collectors.toList());
	 * @param keyExtractor
	 * @param <T>
	 * @return
	 */
	public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
		Set<Object> set = ConcurrentHashMap.newKeySet();
		return t -> set.add(keyExtractor.apply(t));
	}

}
