package cn.jque.core.convert;

import cn.jque.core.model.BehaviorInfo;
import cn.jque.core.model.dto.LessonDTO;
import cn.jque.core.model.dto.UserAndLessonDTO;
import cn.jque.core.model.dto.UserDTO;
import cn.jque.core.model.vo.LessonVO;
import cn.jque.core.model.vo.UserVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-08-17T21:25:07+0800",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 1.8.0_144 (Oracle Corporation)"
)
public class UserConvertImpl implements UserConvert {

    @Override
    public UserDTO convertUserVoToUserDto(UserVO vo) {
        if ( vo == null ) {
            return null;
        }

        UserDTO userDTO = new UserDTO();

        userDTO.setUserId( vo.getUserId() );
        userDTO.setUserName( vo.getUserName() );
        userDTO.setPassword( vo.getPassword() );
        userDTO.setPhone( vo.getPhone() );
        userDTO.setEmail( vo.getEmail() );
        userDTO.setEmailAddress( vo.getEmailAddress() );

        return userDTO;
    }

    @Override
    public List<UserDTO> convertUserVoListToUserDtoList(List<UserVO> userVos) {
        if ( userVos == null ) {
            return null;
        }

        List<UserDTO> list = new ArrayList<UserDTO>( userVos.size() );
        for ( UserVO userVO : userVos ) {
            list.add( convertUserVoToUserDto( userVO ) );
        }

        return list;
    }

    @Override
    public LessonDTO convertLessonVoToLessonDto(LessonVO lessonVo) {
        if ( lessonVo == null ) {
            return null;
        }

        LessonDTO lessonDTO = new LessonDTO();

        lessonDTO.setLessonId( lessonVo.getLessonId() );
        lessonDTO.setLessonName( lessonVo.getLessonName() );
        lessonDTO.setStartDate( lessonVo.getStartDate() );
        lessonDTO.setEndDate( lessonVo.getEndDate() );
        lessonDTO.setCreatedOn( lessonVo.getCreatedOn() );
        List<BehaviorInfo> list = lessonVo.getBehaviorInfos();
        if ( list != null ) {
            lessonDTO.setBehaviorInfos( new ArrayList<BehaviorInfo>( list ) );
        }

        return lessonDTO;
    }

    @Override
    public UserAndLessonDTO convertUserVoAndLessonVoToUserAndLessonDto(UserVO userVo, LessonVO lessonVo) {
        if ( userVo == null && lessonVo == null ) {
            return null;
        }

        UserAndLessonDTO userAndLessonDTO = new UserAndLessonDTO();

        if ( userVo != null ) {
            userAndLessonDTO.setUserId( userVo.getUserId() );
            userAndLessonDTO.setUserName( userVo.getUserName() );
            userAndLessonDTO.setPassword( userVo.getPassword() );
            userAndLessonDTO.setPhone( userVo.getPhone() );
            userAndLessonDTO.setEmail( userVo.getEmail() );
            userAndLessonDTO.setEmailAddress( userVo.getEmailAddress() );
        }
        if ( lessonVo != null ) {
            userAndLessonDTO.setLessonId( lessonVo.getLessonId() );
            userAndLessonDTO.setLessonName( lessonVo.getLessonName() );
            List<BehaviorInfo> list = lessonVo.getBehaviorInfos();
            if ( list != null ) {
                userAndLessonDTO.setBehaviorInfos( new ArrayList<BehaviorInfo>( list ) );
            }
        }
        userAndLessonDTO.setStartDate( new Date() );
        userAndLessonDTO.setEndDate( new Date() );
        userAndLessonDTO.setCreatedOn( LocalDateTime.now() );

        return userAndLessonDTO;
    }
}
