package cn.jque.core.convert;

import cn.jque.core.model.dto.LessonDTO;
import cn.jque.core.model.dto.UserAndLessonDTO;
import cn.jque.core.model.dto.UserDTO;
import cn.jque.core.model.vo.LessonVO;
import cn.jque.core.model.vo.UserVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * @author Liu.ShiTing
 * @version 1.0.0
 * @date 2022-07-06 11:49:36
 */
@Mapper(imports = {LocalDateTime.class, Date.class})
public interface UserConvert {

	UserConvert INSTANCE = Mappers.getMapper(UserConvert.class);

	UserDTO convertUserVoToUserDto(UserVO vo);

	List<UserDTO> convertUserVoListToUserDtoList(List<UserVO> userVos);

	LessonDTO convertLessonVoToLessonDto(LessonVO lessonVo);

	@Mapping(target = "userId", source = "userVo.userId")
	@Mapping(target = "userName", source = "userVo.userName")
	@Mapping(target = "password", source = "userVo.password")
	@Mapping(target = "phone", source = "userVo.phone")
	@Mapping(target = "email", source = "userVo.email")
	@Mapping(target = "emailAddress", source = "userVo.emailAddress")

	@Mapping(target = "lessonId", source = "lessonVo.lessonId")
	@Mapping(target = "lessonName", source = "lessonVo.lessonName")
	@Mapping(target = "startDate", expression = "java(new Date())")
	@Mapping(target = "endDate", expression = "java(new Date())")
	@Mapping(target = "createdOn", expression = "java(LocalDateTime.now())")
	@Mapping(target = "behaviorInfos", source = "lessonVo.behaviorInfos")
	UserAndLessonDTO convertUserVoAndLessonVoToUserAndLessonDto(UserVO userVo, LessonVO lessonVo);

}
