/*
 * Decompiled with CFR 0.152.
 */
package cn.jque.core.util;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String LONG_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String SHORT_TIME_PATTERN = "HH:mm:ss";
    public static final String LONG_DATE_PATTERN_NOSPLIT = "yyyyMMddHHmmss";
    public static final String MINITE_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String CHINA_MINITE_DATE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5  HH:mm";
    public static final String MAIL_CHINA_MINITE_DATE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm (EEE)";
    public static final String CHINA_MONTH_DATE_PATTERN = "MM\u6708dd\u65e5  HH:mm";
    public static final String CHINA_MONTH_DAY_DATE_PATTERN = "MM\u6708dd\u65e5";
    public static final String MINITE_SECOND_PATTERN = "HH:mm";
    public static final long MS_OF_A_DAY = 86400000L;

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, LONG_DATE_PATTERN);
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, SHORT_DATE_PATTERN);
    }

    public static String formatTime(Date date) {
        return DateUtils.format(date, SHORT_TIME_PATTERN);
    }

    public static String format(Date date, String pattern) {
        return date != null ? new DateTime((Object)date).toString(pattern) : "";
    }

    public static String format(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static Date parseDateTime(String source) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)LONG_DATE_PATTERN);
        return fmt.parseDateTime(source).toDate();
    }

    public static Date parseDate(String source) {
        DateTime dateTime = new DateTime((Object)source);
        return dateTime.toDate();
    }

    public static Date parseDate(String source, String pattern) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        return fmt.parseDateTime(source).toDate();
    }

    public static Date parseTime(String source) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)SHORT_TIME_PATTERN);
        return fmt.parseDateTime(source).toDate();
    }

    public static Date addDays(Date pswBeainTime, Integer pswLife) {
        DateTime dateTime = new DateTime((Object)pswBeainTime);
        return dateTime.plusDays(pswLife.intValue()).toDate();
    }

    public static Date minusDays(Date pswBeainTime, Integer pswLife) {
        DateTime dateTime = new DateTime((Object)pswBeainTime);
        return dateTime.minusDays(pswLife.intValue()).toDate();
    }

    public static Date addMinutes(Date lockTime, Integer lockPeriod) {
        DateTime dateTime = new DateTime((Object)lockTime);
        return dateTime.plusMinutes(lockPeriod.intValue()).toDate();
    }

    public static int getCurrentYear() {
        DateTime dateTime = new DateTime();
        return dateTime.getYear();
    }

    public static int getYear(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getYear();
    }

    public static int getMonth(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getMonthOfYear() - 1;
    }

    public static String getWeek(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfWeek().getAsText();
    }

    public static int getDay(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getDayOfMonth();
    }

    public static int getHour(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getHourOfDay();
    }

    public static int getMin(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.getMinuteOfHour();
    }

    public static Date truncateDate(Date date) {
        return date != null ? new LocalDate((Object)date).toDate() : null;
    }

    public static String joinDate(Date startDate, Date endDate) {
        return DateUtils.format(startDate, LONG_DATE_PATTERN) + "-" + DateUtils.format(endDate, SHORT_TIME_PATTERN);
    }
}

