package cn.jque.core.util;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Date;

/**
 * 日期转换工具类
 * @author Liu.ShiTing
 * @version 1.0.0
 * @date 2022-06-28 14:16:40
 */
public class DateUtils {

	public static final String LONG_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

	public static final String SHORT_DATE_PATTERN = "yyyy-MM-dd";

	public static final String SHORT_TIME_PATTERN = "HH:mm:ss";

	public static final String LONG_DATE_PATTERN_NOSPLIT = "yyyyMMddHHmmss";

	public static final String MINITE_DATE_PATTERN = "yyyy-MM-dd HH:mm";

	public static final String CHINA_MINITE_DATE_PATTERN = "yyyy年MM月dd日  HH:mm";

	public static final String MAIL_CHINA_MINITE_DATE_PATTERN = "yyyy年MM月dd日 HH:mm (EEE)";

	public static final String CHINA_MONTH_DATE_PATTERN = "MM月dd日  HH:mm";

	public static final String CHINA_MONTH_DAY_DATE_PATTERN = "MM月dd日";

	public static final String MINITE_SECOND_PATTERN = "HH:mm";

	/**
	 * 一天的毫秒数
	 */
	public static final long MS_OF_A_DAY = 1000 * 60 * 60 * 24;

	public static String formatDateTime(Date date) {
		return format(date, LONG_DATE_PATTERN);
	}

	public static String formatDate(Date date) {
		return format(date, SHORT_DATE_PATTERN);
	}

	public static String formatTime(Date date) {
		return format(date, SHORT_TIME_PATTERN);
	}

	public static String format(Date date, String pattern) {
		return date != null ? new DateTime(date).toString(pattern) : "";
	}

	public static String format(String pattern) {
		return format(new Date(), pattern);
	}

	public static Date parseDateTime(String source) {
		DateTimeFormatter fmt = DateTimeFormat.forPattern(LONG_DATE_PATTERN);
		return fmt.parseDateTime(source).toDate();
	}

	public static Date parseDate(String source) {
		DateTime dateTime = new DateTime(source);
		return dateTime.toDate();
	}

	public static Date parseDate(String source, String pattern) {
		DateTimeFormatter fmt = DateTimeFormat.forPattern(pattern);
		return fmt.parseDateTime(source).toDate();
	}

	public static Date parseTime(String source) {
		DateTimeFormatter fmt = DateTimeFormat.forPattern(SHORT_TIME_PATTERN);
		return fmt.parseDateTime(source).toDate();
	}

	public static Date addDays(Date pswBeainTime, Integer pswLife) {
		DateTime dateTime = new DateTime(pswBeainTime);
		return dateTime.plusDays(pswLife).toDate();
	}

	public static Date minusDays(Date pswBeainTime, Integer pswLife) {
		DateTime dateTime = new DateTime(pswBeainTime);
		return dateTime.minusDays(pswLife).toDate();
	}

	public static Date addMinutes(Date lockTime, Integer lockPeriod) {
		DateTime dateTime = new DateTime(lockTime);
		return dateTime.plusMinutes(lockPeriod).toDate();
	}

	public static int getCurrentYear() {
		DateTime dateTime = new DateTime();
		return dateTime.getYear();
	}

	public static int getYear(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.getYear();
	}

	public static int getMonth(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.getMonthOfYear() - 1;
	}

	public static String getWeek(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.dayOfWeek().getAsText();
	}

	public static int getDay(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.getDayOfMonth();
	}

	public static int getHour(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.getHourOfDay();
	}

	public static int getMin(Date date) {
		DateTime dateTime = new DateTime(date);
		return dateTime.getMinuteOfHour();
	}

	/**
	 * 描述: 截取 date 到年月日日期
	 * @param date
	 * @return
	 */
	public static Date truncateDate(Date date) {
		return date != null ? new LocalDate(date).toDate() : null;
	}

	/**
	 * 描述: 链接两个日期,默认认为是同一天,不考虑跨天的情况
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public static String joinDate(Date startDate, Date endDate) {
		return format(startDate, LONG_DATE_PATTERN) + "-" + format(endDate, SHORT_TIME_PATTERN);
	}

}
