/*
 * Decompiled with CFR 0.152.
 */
package cn.jque.common.enums;

import cn.jque.common.enums.ErrorCode;
import cn.jque.common.enums.Init;
import java.io.Serializable;

public interface BaseErrorCode
extends Serializable {
    default public int getApp() {
        return Init.DEFAULT_APP_CODE;
    }

    default public int getModule() {
        return Init.DEFAULT_MODULE_CODE;
    }

    default public int getRealCode() {
        int rc = this.getCode();
        if (this.getRealModule() > 0) {
            rc += this.getRealApp();
        }
        if (this.getRealModule() > 0) {
            rc += this.getRealModule();
        }
        return rc;
    }

    default public int getRealApp() {
        return this.getRealApp(this.getApp());
    }

    default public int getRealModule() {
        return this.getRealModule(this.getModule());
    }

    default public int getRealApp(int app) {
        return app > 0 ? app : Init.DEFAULT_APP_CODE;
    }

    default public int getRealModule(int module) {
        return module > 0 ? module : Init.DEFAULT_MODULE_CODE;
    }

    default public void check() {
        ErrorCode.check(this.getRealApp(), this.getRealModule(), this.getCode());
    }

    public int getCode();

    public String getName();
}

