package cn.jque.common.exception;

import cn.jque.common.enums.BaseErrorCode;
import cn.jque.common.enums.CustomErrorCode;
import org.springframework.http.HttpStatus;

public class BusinessRequestException extends BadRequestException {

	public BusinessRequestException(HttpStatus status, Integer code, String message) {
		super(status, new CustomErrorCode(code, message));
	}

	public BusinessRequestException(Integer code, String message) {
		super(HttpStatus.BAD_REQUEST, new CustomErrorCode(code, message));
	}

	public BusinessRequestException(BaseErrorCode error) {
		super(HttpStatus.BAD_REQUEST, error);
	}
}