package cn.jque.common.enums;

import lombok.Getter;

@Getter
public enum ResponseEnum {

	/**
	 * 成功
	 */
	SUCCESS(200, "操作成功"),

	/**
	 * 失败
	 */
	FAILURE(500, "操作失败"),

	/**
	 * 服务器异常
	 */
	SERVER_EXCEPTION(7000, "Invalid"),

	/**
	 * Bad licence type
	 */
	BAD_LICENCE_TYPE(7001, "Bad licence type."),

	/**
	 * Licence not found
	 */
	LICENCE_NOT_FOUND(7002, "Licence not found.");

	/**
	 * 返回码
	 */
	private final int code;
	/**
	 * 返回消息
	 */
	private final String message;

	ResponseEnum(int code, String message) {
		this.code = code;
		this.message = message;
	}
}
