package cn.jque.common.enums;

import java.util.Arrays;

public interface ErrorCode extends BaseErrorCode {

	static ErrorCode of(int code, String name) {
		return new CustomErrorCode(code, name);
	}

	static ErrorCode of(int appCode, int moduleCode, int code, String name) {
		return of(name, appCode, moduleCode, code);
	}

	static ErrorCode of(int moduleCode, int code, String name) {
		return of(name, moduleCode, code);
	}

	static ErrorCode of(BaseErrorCode errorCode) {
		return new CustomErrorCode(errorCode.getRealApp(), errorCode.getRealModule(), errorCode.getCode(), errorCode.getName());
	}

	static ErrorCode format(BaseErrorCode errorCode, Object... params) {
		return new CustomErrorCode(errorCode.getApp(), errorCode.getModule(), errorCode.getCode(), String.format(errorCode.getName(), params));
	}

	static ErrorCode of(String name, int... codeParts) {
		if (codeParts.length == 1) {
			return new CustomErrorCode(codeParts[0], name);
		} else if (codeParts.length == 2) {
			return new CustomErrorCode(codeParts[0], codeParts[1], name);
		} else if (codeParts.length == 3) {
			return new CustomErrorCode(codeParts[0], codeParts[1], codeParts[2], name);
		} else {
			int code = Arrays.stream(codeParts).sum();
			return new CustomErrorCode(code, name);
		}
	}

	static void check(int app, int module, int code) {
		if (module > 0 && getNumLength(module) <= getNumLength(code)) {
			throw new IllegalArgumentException(String.format("参数[module=%d]的位数必须大于参数[code=%d]", module, code));
		} else {
			if (app > 0) {
				if (module > 0 && getNumLength(app) <= getNumLength(module)) {
					throw new IllegalArgumentException(String.format("参数[app=%d]的位数必须大于参数[module=%d]", app, module));
				}

				if (getNumLength(app) <= getNumLength(code)) {
					throw new IllegalArgumentException(String.format("参数[app=%d]的位数必须大于参数[code=%d]", app, code));
				}
			}

		}
	}

	static int getNumLength(int num) {
		num = num > 0 ? num : -num;
		return String.valueOf(num).length();
	}
}
