/*
 * Decompiled with CFR 0.152.
 */
package cn.jque.common.enums;

import cn.jque.common.enums.BaseErrorCode;
import cn.jque.common.enums.CustomErrorCode;
import java.util.Arrays;

public interface ErrorCode
extends BaseErrorCode {
    public static ErrorCode of(int code, String name) {
        return new CustomErrorCode(code, name);
    }

    public static ErrorCode of(int appCode, int moduleCode, int code, String name) {
        return ErrorCode.of(name, appCode, moduleCode, code);
    }

    public static ErrorCode of(int moduleCode, int code, String name) {
        return ErrorCode.of(name, moduleCode, code);
    }

    public static ErrorCode of(BaseErrorCode errorCode) {
        return new CustomErrorCode(errorCode.getRealApp(), errorCode.getRealModule(), errorCode.getCode(), errorCode.getName());
    }

    public static ErrorCode format(BaseErrorCode errorCode, Object ... params) {
        return new CustomErrorCode(errorCode.getApp(), errorCode.getModule(), errorCode.getCode(), String.format(errorCode.getName(), params));
    }

    public static ErrorCode of(String name, int ... codeParts) {
        if (codeParts.length == 1) {
            return new CustomErrorCode(codeParts[0], name);
        }
        if (codeParts.length == 2) {
            return new CustomErrorCode(codeParts[0], codeParts[1], name);
        }
        if (codeParts.length == 3) {
            return new CustomErrorCode(codeParts[0], codeParts[1], codeParts[2], name);
        }
        int code = Arrays.stream(codeParts).sum();
        return new CustomErrorCode(code, name);
    }

    public static void check(int app, int module, int code) {
        if (module > 0 && ErrorCode.getNumLength(module) <= ErrorCode.getNumLength(code)) {
            throw new IllegalArgumentException(String.format("\u53c2\u6570[module=%d]\u7684\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e\u53c2\u6570[code=%d]", module, code));
        }
        if (app > 0) {
            if (module > 0 && ErrorCode.getNumLength(app) <= ErrorCode.getNumLength(module)) {
                throw new IllegalArgumentException(String.format("\u53c2\u6570[app=%d]\u7684\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e\u53c2\u6570[module=%d]", app, module));
            }
            if (ErrorCode.getNumLength(app) <= ErrorCode.getNumLength(code)) {
                throw new IllegalArgumentException(String.format("\u53c2\u6570[app=%d]\u7684\u4f4d\u6570\u5fc5\u987b\u5927\u4e8e\u53c2\u6570[code=%d]", app, code));
            }
        }
    }

    public static int getNumLength(int num) {
        num = num > 0 ? num : -num;
        return String.valueOf(num).length();
    }
}

