package cn.jque.common.enums;

import lombok.Data;

@Data
public class CustomErrorCode implements ErrorCode {

	private static final long serialVersionUID = -1346792776866901465L;

	private int app;
	private int module;
	private int code;
	private String name;

	public static CustomErrorCode wrapper(BaseErrorCode errorCode) {
		return new CustomErrorCode(errorCode.getCode(), errorCode.getName());
	}

	public CustomErrorCode(int app, int module, int code, String name) {
		this.app = app;
		this.module = module;
		this.code = code;
		this.name = name;
		this.check();
	}

	public CustomErrorCode(int module, int code, String name) {
		this.module = module;
		this.code = code;
		this.name = name;
		this.check();
	}

	public CustomErrorCode(int code, String name) {
		this.code = code;
		this.name = name;
		this.check();
	}

	@Override
	public boolean equals(Object o) {
		if (o == this) {
			return true;
		} else if (!(o instanceof CustomErrorCode)) {
			return false;
		} else {
			CustomErrorCode other = (CustomErrorCode) o;
			if (!other.canEqual(this)) {
				return false;
			} else if (this.getApp() != other.getApp()) {
				return false;
			} else if (this.getModule() != other.getModule()) {
				return false;
			} else if (this.getCode() != other.getCode()) {
				return false;
			} else {
				Object this$name = this.getName();
				Object other$name = other.getName();
				if (this$name == null) {
					if (other$name != null) {
						return false;
					}
				} else if (!this$name.equals(other$name)) {
					return false;
				}

				return true;
			}
		}
	}

	protected boolean canEqual(Object other) {
		return other instanceof CustomErrorCode;
	}

	@Override
	public int hashCode() {
		//int PRIME = true;
		int result = 1;
		result = result * 59 + this.getApp();
		result = result * 59 + this.getModule();
		result = result * 59 + this.getCode();
		Object $name = this.getName();
		result = result * 59 + ($name == null ? 43 : $name.hashCode());
		return result;
	}

	@Override
	public String toString() {
		return "CustomErrorCode(app=" + this.getApp() + ", module=" + this.getModule() + ", code=" + this.getCode() + ", name=" + this.getName() + ")";
	}

	public CustomErrorCode() {
	}
}
