package cn.jque.common.enums;

import java.io.Serializable;

/**
 * @author Liu.ShiTing
 * @version 3.0
 * @date 2022-01-20 21:10:19
 */
public interface BaseErrorCode extends Serializable {

	default int getApp() {
		return Init.DEFAULT_APP_CODE;
	}

	default int getModule() {
		return Init.DEFAULT_MODULE_CODE;
	}

	default int getRealCode() {
		int rc = this.getCode();
		if (this.getRealModule() > 0) {
			rc += this.getRealApp();
		}

		if (this.getRealModule() > 0) {
			rc += this.getRealModule();
		}

		return rc;
	}

	default int getRealApp() {
		return this.getRealApp(this.getApp());
	}

	default int getRealModule() {
		return this.getRealModule(this.getModule());
	}

	default int getRealApp(int app) {
		return app > 0 ? app : Init.DEFAULT_APP_CODE;
	}

	default int getRealModule(int module) {
		return module > 0 ? module : Init.DEFAULT_MODULE_CODE;
	}

	default void check() {
		ErrorCode.check(this.getRealApp(), this.getRealModule(), this.getCode());
	}

	int getCode();

	String getName();

}
